<?php
require_once("syno_conf.php");

// the value of folder delimiter should by sync with DS Assistant Photo uploader
$SZ_FOLDER_DELIMITER = '/FolderDelimiter/';

$SZ_SESSION_LOST = 'session_lost';

$uploadable_folders = array();

$result['no_privilege_files'] = array();
$result['duplicated_files'] = array();
$result['success'] = true;
$result['err_msg'] = '';

if (false == isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && false == isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
	$result['success'] = false;
	$result['err_msg'] = $SZ_SESSION_LOST;
}

if ($result['success'] && !isset($_POST['filelist'])) {
	$result['success'] = false;
	$result['err_msg'] = 'bad parameter';
}

// reset uploadable album list in session
csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

if ($result['success']) {
	$upload_files = explode($SZ_FOLDER_DELIMITER, $_POST['filelist']);
	foreach ($upload_files as $file) {
		ASST_PHOTO_UPLOAD_CheckFilePrivilegeAndDuplicated($file);
	}
}

// transform from unicode back to utf8
echo preg_replace("#\\\u([0-9a-f]{4}+)#ie", "iconv('UCS-2', 'UTF-8', pack('H4', '\\1'))", json_encode($result));

function ASST_PHOTO_UPLOAD_CheckFilePrivilegeAndDuplicated($file)
{
        global $result, $uploadable_folders;

	$filepath = str_replace('//', '/', SYNOPHOTO_SERVICE_DIR.'/'.$file);

	if (file_exists($filepath)) {
		$result['duplicated_files'][] = $file;
	}

        if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
                // only check privilege for non-admin condition
                $albums = explode('/', trim($file, '/')); // trim the first '/' if required (occurs when file is under /photo directory)
                $folder_level = count($albums) - 1; // remove the file name itself (ex. 123.jpg), only keeps the album name
                if (0 == $folder_level) {
                        $sharename = '/';
                        $is_album_exists = true;
                } else if (1 == $folder_level) {
                        $sharename = $albums[0];
                        $is_album_exists = file_exists(SYNOPHOTO_SERVICE_DIR.'/'.$sharename);
                } else if (2 <= $folder_level) {
                        $sharename = $albums[0].'/'.$albums[1];
                        $is_album_exists = file_exists(SYNOPHOTO_SERVICE_DIR.'/'.$sharename);
                }

                if (false == $is_album_exists) {
                        // if album not exists, check if it in upload queue and uploadable
                        $blprivilege = in_array($sharename, $uploadable_folders);
                } else {
                        $blprivilege = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$sharename]);
                }

                if (false == $blprivilege) {
                        $result['no_privilege_files'][] = $file;
                } else if (true == $blprivilege) {
                        if (0 == $folder_level) {
                                $uploadable_folders[] = $albums[0];
                        } else if (1 == $folder_level) {
                                $uploadable_folders[] = $albums[0].'/'.$albums[1];
                        }
                }
        }
}


?>
