<?php
require_once(dirname(__FILE__).'/../../include/syno_conf.php');

switch ($_POST['action'])
{
	case 'get_module_content':
		echo LABEL_CLOUD_GetModuleContent(false);
		break;
}

function LABEL_CLOUD_GetModuleContent($isReturnData=true)
{
	global $smarty;

	$num = 0;
	if ($num > 0) {
		$limit_condi = 'desc limit '.$num;
	}
	$query = 'Select * from blog_label where article_count > 0 order by article_count '.$limit_condi;
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$rows = PHOTO_DB_FetchAll($db_result);
	if (false === $db_result || 0 == count($rows)) {
		return null;
	} else {
		$font_size_array = LABEL_CLOUD_GetFontSize();
		$label_list = array();
		foreach ($rows as $row) {
			if(!($article_count = LABEL_CLOUD_GetArticleNum($row['label_id']))) {
				continue;
			}
			$label['name'] = htmlspecialchars($row['label_name']);
			if($row['label_name'] == 'no_label') {
				$label['name'] = __('photo_str_no_label');
			}
			$label['link'] = "javascript:onNavigate('label_".$row['label_id']."');";
			$label['title'] = $label['name']."($article_count)";
			$label['class'] = 'label-font-'.$font_size_array[''.$article_count];
			$label_list[] = $label;
		}
		if ($isReturnData) {
			return $label_list;
		}
		$result['content'] = $label_list;
		$smarty->assign('module', $result);
		return $smarty->Fetch('blog/module/label_cloud.tpl');
	}
}

function LABEL_CLOUD_GetArticleNum($label_id)
{
	$query = 'Select article_count from blog_label where label_id = '.$label_id;
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);
	$label_count = $row['article_count'];
	$i = 0;
	$query = 'Select article_id from blog_article_label where label_id = '.$label_id;
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$query = 'Select draft from blog_article where article_id = '.$row['article_id'];
		$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$row_2 = PHOTO_DB_FetchRow($db_result_2);
		if($row_2['draft'] == -1 || $row_2['draft'] == 1) {
			$i++;
		}
	}
	return $label_count - $i;
}

function LABEL_CLOUD_GetFontSize()
{
	$size['0.4'] = 12;
	$size['0.65'] = 18;
	$size['0.8'] = 24;
	$size['0.9'] = 30;
	$size['1'] = 36;

	$arr = array();

	$query = 'Select * from blog_label where article_count > 0 order by article_count asc';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	while(($row = PHOTO_DB_FetchRow($db_result))) {
		if(!($article_count = LABEL_CLOUD_GetArticleNum($row[0]))) {
			continue;
		}
		$arr[] = $article_count;
	}

	$arr = array_unique($arr);

	$category_num = count($arr);
	if($category_num < 5) {
		$category_num = 5;
	}

	$count = 1;
	foreach ($arr as $tok) {
		$result[''.$tok] = $size[LABEL_CLOUD_GetLevel($count/$category_num)];
		$count++;
	}
	return $result;
}

function LABEL_CLOUD_GetLevel($num)
{
	if($num <= 0.4) {
		return '0.4';
	} else if($num > 0.4 && $num <= 0.65) {
		return '0.65';
	} else if($num > 0.65 && $num <= 0.8) {
		return '0.8';
	} else if($num > 0.8 && $num <= 0.9) {
		return '0.9';
	} else if($num > 0.9 && $num <= 1) {
		return '1';
	}
}
?>
