<?php
require_once("../include/syno_conf.php");
require_once(SYNOPHOTO_ADMIN_ACCESS_RIGHT);


if (preg_match('/^(get_dsm_user)$/', $_POST['action'])) {
	csSYNOPhotoMisc::CheckAdminTimeOut();
}
if(isset($_POST['start']) && isset($_POST['limit']) && 'get_access_right' != $_POST['action'] && (!isset($_POST['action']) || 'get_dsm_user' != $_POST['action'])) {
	echo SYNOPHOTO_ADMIN_GetAllUser($_POST['start'], $_POST['limit']);
} else {

	switch ($_POST['action']) {
	case 'get_user_type':
		echo SYNPHOTO_GET_USER_TYPE();
		break;
	case 'delete_user':
		echo SYNOPHOTO_ADMIN_DeteleUser($_POST['uid']);
		break;
	case 'get_user_data':
		echo SYNOPHOTO_ADMIN_GetUserDataByUid($_POST['uid']);
		break;
	case 'get_reg_user_data':
		echo SYNOPHOTO_ADMIN_GetRegUserData();
		break;
	case 'get_reg_dsm_user_data':
		echo SYNOPHOTO_ADMIN_GetRegDSMUserData();
		break;
	case 'update_user':
		echo SYNOPHOTO_ADMIN_UpdateUser($_POST['uid']);
		break;
	case 'update_reg_user_data':
		echo SYNOPHOTO_ADMIN_UpdateRegUserData($_POST['uid']);
		break;
	case 'get_dsm_user':
		echo SYNOPHOTO_ADMIN_GetAllDSMUser($_POST['start']);
		break;
	}
}

function  SYNPHOTO_GET_USER_TYPE()
{
	$result['type'] = csSYNOPhotoMisc::GetUserType();
	$result['root_only'] = $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] ? '0' : '1';
	$result['admin'] = SYNOPHOTO_ADMIN_NAME;
	$result['use_dsm_account'] = SYNOPHOTO_URL_PREFIX ? '0' : csSYNOPhotoMisc::GetConfigDB("global", "account_system", "photo_config");

        if ('root' === SYNOPHOTO_ADMIN_USER) {
            $result['username'] = (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) ? 'admin' : $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
        } else {
        // personal photo
            $result['username'] = (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) ? SYNOPHOTO_ADMIN_NAME : $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
        }

	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetAllUser($start, $limit)
{
	if (isset($_POST['query'])) {
		$escape = PHOTO_DB_GetEscape();
		$query = "SELECT count(userid) FROM photo_user WHERE username LIKE ? $escape";
		$sqlParam = array("%" . PHOTO_DB_EscapForLike($_POST['query']) . "%");
	} else {
		$query = "Select count(userid) from photo_user";
		$sqlParam = array();
	}
	$count = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query, $sqlParam);
	$result['totalCount'] = $count;

	if (isset($_POST['query'])) {
		$escape = PHOTO_DB_GetEscape();
		$query = "SELECT * FROM photo_user WHERE username LIKE ? $escape ORDER BY username ASC LIMIT ? OFFSET ?";
		$sqlParam = array("%" . PHOTO_DB_EscapForLike($_POST['query']) . "%", $limit, $start);
	} else {
		$query = "Select * from photo_user order by username asc limit ? offset ?";
		$sqlParam = array($limit, $start);
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$result['all_users'] = array();
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$item = array();
		$item['userid'] = $row[0];
		$item['username'] = $row[1];
		$item['description'] = htmlspecialchars($row[2], ENT_QUOTES);
		$item['disable'] = PHOTO_DB_ConvertBool($row[4]);
		$item['lock_pass'] = PHOTO_DB_ConvertBool($row[5]);
		$item['admin'] = PHOTO_DB_ConvertBool($row[6]);
		$item['email'] = $row[7];
		$item['is_reg_user_admin_login'] = ($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] == $row[1]);
		$result['all_users'][] = $item;
		$i++;
	}

	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetAllDSMUser($start, $limit=15, $query='')
{
	if (isset($_POST['query'])) {
	    $query = $_POST['query'];
	}

	$command = "/usr/syno/bin/synophoto_dsm_user --enum " . escapeshellarg($query);
	@exec($command, $pListUserCount, $retval);
	if (0 > $retval) {
		$result['totalCount'] = 0;
		return json_encode($result);
	}
	$result['totalCount'] = $pListUserCount[0];

	/* get the order of user info */
	if (!isset($_POST['dir']) || $_POST['dir'] !== 'DESC') {
	    $dir = "ASC";
	} else {
	    $dir = "DESC";
	}

	/* if dir is descending, re-compute the index of admin and guest */
	if ($dir === "DESC") {
	    if (isset($pListUserCount[1])) {
		$pListUserCount[1] = $result['totalCount'] - $pListUserCount[1] - 1;
	    }
	    if (isset($pListUserCount[2])) {
		$pListUserCount[2] = $result['totalCount'] - $pListUserCount[2] - 1;
	    }
	}

	/* modify start value to skip admin and guest */
	if (isset($pListUserCount[1])) {
	    $result['totalCount'] --;
	    if ($pListUserCount[1] < $start) {
		$start += 1;
	    }
	}
	if (isset($pListUserCount[2])) {
	    $result['totalCount'] --;
	    if ($pListUserCount[2] < $start) {
		$start += 1;
	    }
	}
	/* modify limit value accoring to start value */
	if (isset($pListUserCount[1])) {
	    if ($start <= $pListUserCount[1] && $pListUserCount[1] < $start + $limit) {
		$limit += 1;
	    }
	}
	if (isset($pListUserCount[2])) {
	    if ($start <= $pListUserCount[2] && $pListUserCount[2] < $start + $limit) {
		$limit += 1;
	    }
	}

	$command = "/usr/syno/bin/synophoto_dsm_user --enum " . escapeshellarg($start) . " " . escapeshellarg($limit) . " " . $dir . ":" . escapeshellarg($query);
	@exec($command, $pListUserName, $retval);

	if (0 !== $retval) {
	    $result['totalCount'] = 0;
	    return json_encode($result);
	}

	$i = 0;
	$result['all_users'] = array();
	foreach ($pListUserName as $user_str) {
		$user_info = split(',', $user_str);
		if ('guest' == $user_info[1] || 'admin' == $user_info[1]) {
			continue;
		}

		$result['all_users'][$i]['userid'] = $user_info[0];
		$result['all_users'][$i]['username'] = $user_info[1];
		$result['all_users'][$i]['description'] = htmlspecialchars($user_info[2], ENT_QUOTES);
		$result['all_users'][$i]['disable'] = ($user_info[3] == 'true') ? "t" : "f";
		$result['all_users'][$i]['admin'] = ($user_info[5] == 1) ? "t" : "f";

		$i++;
	}

	return json_encode($result);
}

function SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser)
{
	global $SYNOPHOTO_DSM_USER_INFO;
	$result = array();
	if (!is_array($pUser)) {
		return null;
	}
	foreach ($pUser as $item) {
		if (!preg_match('/(^\w+\s?\w+)\s*\:/', $item, $match) || !preg_match('/\[(.*)\]/', $item, $match_val)) {
			continue;
		}

		if (false !== $index = array_search($match[1], $SYNOPHOTO_DSM_USER_INFO)) {
			$result[$index] = $match_val[1];
		}
	}
	return $result;
}

function SYNOPHOTO_ADMIN_GetUserDataByUid($uid)
{
	$query = "Select * from photo_user where userid = ?";
	$sqlParam = array($uid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if(($row = PHOTO_DB_FetchRow($db_result))) {
		$result['data']['username'] = $row[1];
		$result['data']['description'] = $row[2];
		$result['data']['disabled'] = (PHOTO_DB_ConvertBool($row[4]) == 't') ? 'on' : 'off';
		$result['data']['lock_pass'] = (PHOTO_DB_ConvertBool($row[5]) == 't') ? 'on' : 'off';
		$result['data']['admin'] = (PHOTO_DB_ConvertBool($row[6]) == 't') ? 'on' : 'off';
		$result['data']['email'] = $row[7];
	}
	if($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] == $result['data']['username']) {
		$result['data']['is_reg_user_admin_login'] = TRUE;
	} else {
		$result['data']['is_reg_user_admin_login'] = FALSE;
	}

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetRegUserData()
{
	csSYNOPhotoMisc::CheckUserTimeOut();

	$escape = PHOTO_DB_GetEscape();
	$query = "Select * from photo_user where username like ? $escape";
	$sqlParam = array(PHOTO_DB_EscapForLike($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']));
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if(($row = PHOTO_DB_FetchRow($db_result))) {
		$result['data']['uid'] = $row[0];
		$result['data']['username'] = $row[1];
		$result['data']['description'] = $row[2];
		$result['data']['disable_account'] = PHOTO_DB_ConvertBool($row[4]);
		$result['data']['lock_info'] = PHOTO_DB_ConvertBool($row[5]);
		$result['data']['set_as_admin'] = PHOTO_DB_ConvertBool($row[6]);
		$result['data']['email'] = $row[7];
		$result['success'] = TRUE;
	}

	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetRegDSMUserData()
{

	$result = array();
	$command = "/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']);
	@exec($command, $pUser, $retval);
	if (0 != $retval) {
		return json_encode($result);
	}
	$user_info = SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser);

	if ($user_info) {
		$result['data']['uid'] = $user_info[2];
		$result['data']['username'] = $user_info[0];
		$result['data']['description'] = htmlspecialchars($user_info[4], ENT_QUOTES);
		$result['data']['disable_account'] = ($user_info[7] == 'true') ? "t" : "f";
		$result['data']['email'] = $user_info[8];
		$result['success'] = TRUE;
	}
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_DeteleUser($uid)
{
	csSYNOPhotoMisc::CheckAdminTimeOut();

	$query = "Delete from photo_user where userid = ?";
	$sqlParam = array($uid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	SYNOPHOTO_ADMIN_DeleteAccessRightByUidAll($uid);

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_UpdateUser($uid)
{
	csSYNOPhotoMisc::CheckAdminTimeOut();

	if ($uid == -1) {
		return SYNOPHOTO_ADMIN_AddUser();
	}

	if (false == $_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
		$query = "Update photo_user set ";
		$query = $query."description = ?, ";
		$query = $query."email = ?, ";
		$sqlParam = array($_POST['description'], $_POST['email']);

		if ($_POST['password'] != '12345678' && $_POST['confirm_password'] != '87654321') {
			$query = $query."password = ?, ";
			$sqlParam[] = md5($_POST['password']);
		}

		if ($_POST['lock_pass'] == 'on') {
			$query = $query."lock_pass = 't', ";
		} else {
			$query = $query."lock_pass = 'f', ";
		}

		if ($_POST['admin'] == 'on') {
			$query = $query."admin = 't', ";
		} else if ('true' == $_POST['modify_admin']) {
			$query = $query."admin = 'f', ";
		}

		if ($_POST['disabled'] == 'on') {
			$query = $query."disabled = 't'";
		} else {
			$query = $query."disabled = 'f'";
		}

		$query = $query."where userid = ?";
		$sqlParam[] = $uid;

		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	}

	SYNOPHOTO_ADMIN_DeleteAccessRightByUid($_POST['uid'], $_POST['delete_album']);
	SYNOPHOTO_ADMIN_AddAccessRightByUid($_POST['uid'], $_POST['add_album']);
	SYNOPHOTO_ADMIN_DeleteUploadPermissionByUid($_POST['uid'], $_POST['delete_upload_permision']);
	SYNOPHOTO_ADMIN_AddUploadPermissionByUid($_POST['uid'], $_POST['add_upload_permision']);
	SYNOPHOTO_ADMIN_DeleteManagePermissionByUid($_POST['uid'], $_POST['delete_manage_permision']);
	SYNOPHOTO_ADMIN_AddManagePermissionByUid($_POST['uid'], $_POST['add_manage_permision']);

	$result['uid'] = $uid;
	$result['success'] = TRUE;

	return json_encode($result);
}

function SYNOPHOTO_ADMIN_UpdateRegUserData()
{
	csSYNOPhotoMisc::CheckUserTimeOut();

	$query = "Update photo_user set ";
	$query = $query."description = '".PHOTO_DB_EscapeParam($_POST['description'])."', ";
	$query = $query."email = '".PHOTO_DB_EscapeParam($_POST['email'])."'";

	if($_POST['passwd'] != '12345678' && $_POST['confirm_passwd'] != '87654321') {
		$query = $query.", password = '".md5($_POST['passwd'])."'";
	}

	$query = $query."where userid = ?";
	$sqlParam = array($_POST['uid']);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	return SYNOPHOTO_ADMIN_GetRegUserData();
}

function SYNOPHOTO_ADMIN_AddUser()
{
	csSYNOPhotoMisc::CheckAdminTimeOut();

	if (in_array(strtolower($_POST['username']), array('admin', 'root', strtolower(SYNOPHOTO_ADMIN_NAME)))) {
		$result['success'] = "account_invalid";
		return json_encode($result);
	}

	$escape = PHOTO_DB_GetEscape();
	$query = "Select count(username) from photo_user where lower(username) like ? $escape";
	$sqlParam = array(PHOTO_DB_EscapForLike(strtolower($_POST['username'])));
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	$row = PHOTO_DB_FetchRow($db_result);
	if($row[0] >= 1) {
		$result['success'] = "account_existed";
		return json_encode($result);
	}

	//get the last member ID in the DB and generate the next ID
	$query = "Select max(userid) from photo_user";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$max_uid = PHOTO_DB_FetchRow($db_result);
	$new_uid = $max_uid[0] + 1;

	$query = "Insert into photo_user (userid, username, password, description, lock_pass, admin, disabled, email) values
						(".$new_uid.", ?, ?, ?, '";
	$sqlParam = array($_POST['username'], md5($_POST['password']), $_POST['description']);
	if($_POST['lock_pass'] == 'on') {
		$query = $query."t";
	} else {
		$query = $query."f";
	}

	$query = $query."', '";

	if($_POST['admin'] == 'on') {
		$query = $query."t";
	} else {
		$query = $query."f";
	}

	$query = $query."', '";

	if($_POST['disabled'] == 'on') {
		$query = $query."t";
	} else {
		$query = $query."f";
	}

	$query = $query."', ?)";
	$sqlParam[] = $_POST['email'];

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	SYNOPHOTO_ADMIN_AddAccessRightByUid($new_uid, $_POST['add_user']);

	$result['uid'] = $new_uid;
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetAllUsersForAlbum()
{
	if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
	    return SYNOPHOTO_ADMIN_GetAllDSMUser($_POST['start']);
	}

	$i = 0;
	$query = "Select * from photo_user where admin = 'f' order by username asc";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$result['all_users'][$i]['userid'] = $row['userid'];
		$result['all_users'][$i]['username'] = $row['username'];
		$result['all_users'][$i]['description'] = $row['description'];
		$i++;
	}
	$result['totalCount'] = $i;
	return json_encode($result);

}
?>
