#!/bin/sh

FILE_MEDIASERVER_PKG_INFO=/var/packages/MediaServer/INFO
FILE_MEDIASERVER_PKG_ENABLE=/var/packages/MediaServer/enabled

MEDIASERVER_SCRIPT=/var/packages/MediaServer/target/scripts/S86synodms.sh

PackageInfoGet() {
	if [ -f "${FILE_MEDIASERVER_PKG_INFO}" ]; then
		MEDIASERVER_PKG_NAME=`/bin/get_key_value ${FILE_MEDIASERVER_PKG_INFO} package`
		MEDIASERVER_PKG_VERSION=`/bin/get_key_value ${FILE_MEDIASERVER_PKG_INFO} version`
		MEDIASERVER_PKG_VENDOR=`/bin/get_key_value ${FILE_MEDIASERVER_PKG_INFO} maintainer`
		MEDIASERVER_PKG_MODVER=`/bin/get_key_value ${FILE_MEDIASERVER_PKG_INFO} sdkmodversion`
		MEDIASERVER_PKG_SHAREVER=`/bin/get_key_value ${FILE_MEDIASERVER_PKG_INFO} sdkshareversion`
		MEDIASERVER_PKG_NETIFNAMEVER=`/bin/get_key_value ${FILE_MEDIASERVER_PKG_INFO} sdknetifnameversion`
	else
		echo "MediaServer package info file does not exist";
		exit 1;
	fi
}

PackageEnableGet() {
	if [ -f "${FILE_MEDIASERVER_PKG_ENABLE}" ]; then
		MEDIASERVER_PKG_ENABLE=1;
	else
		MEDIASERVER_PKG_ENABLE=0;
	fi
}

MediaServerRestart() {
	${MEDIASERVER_SCRIPT} restart
}

ReloadIndexFolders() {
	PidFile="/var/run/dms.pid"
	if [ -f "$PidFile" ]; then
		Pid=`cat $PidFile`
		kill -CONT $Pid > /dev/null 2>&1
	fi
}

ShareChangeCheck() {
	if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ] || [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ] || [ "${ORIGIN_SHARE_STATUS}" = "normal" -a "${SHARE_STATUS}" = "decrypt" ]; then
		NEED_HOOK=1;
	else
		NEED_HOOK=0;
	fi
}

