#!/bin/sh

PACKAGE_DIR="/var/packages/MediaServer"
dms="${PACKAGE_DIR}/target/sbin/dms"
lighttpd="${PACKAGE_DIR}/target/sbin/lighttpd"
httpconf="${PACKAGE_DIR}/target/etc/lighttpd.conf"
httpdebug="${PACKAGE_DIR}/target/etc/lighttpd.debug"
httpdpid=/var/run/lighttpd.pid
pidfile=/var/run/dms.pid
lighttpdlog=/var/log/lighttpd

dmsinfo="${PACKAGE_DIR}/etc/dmsinfo.conf"
LIGHTTPD_MODULE_DIR="${PACKAGE_DIR}/target/lib/lighttpd"

case $1 in
        start)
		eval $(grep "^runpgsql=" /etc/synoinfo.conf)
                case "${runpgsql}" in
                [Yy][Ee][Ss])
                         ;;
                *)
                         echo "PGSQL service is disabled. Skip..."
                         exit 1;
                         ;;
                esac

		/usr/bin/killall -9 dms > /dev/null 2>&1
		/usr/bin/killall -9 lighttpd > /dev/null 2>&1

		DebugLevel=`/bin/get_key_value ${dmsinfo} loglevel_mediaservice`
        echo "Starting Media Service ..."
		# lighttpd must be started after dms for getting ip from /var/run/dms.ip
		${dms}
		if [ "x${DebugLevel}" != "x" ]; then
			/bin/mkdir -p ${lighttpdlog}
			${lighttpd} -f ${httpdebug} -m ${LIGHTTPD_MODULE_DIR}
		else
			${lighttpd} -f ${httpconf}  -m ${LIGHTTPD_MODULE_DIR}
		fi

        ;;
        stop)
            echo "Stopping Media Service ..."
	    if [ -f "$pidfile" ]; then
	            /bin/kill  `cat ${pidfile}` > /dev/null 2>&1
		    sleep 3
		    /usr/bin/killall -9 dms > /dev/null 2>&1
		    /bin/rm ${pidfile} > /dev/null 2>&1
	    fi
	    /bin/kill  `cat ${httpdpid}`  > /dev/null 2>&1
        ;;
        restart)
	        $0 stop
                $0 start
        ;;
        *)
                echo "Usage: $0 start|stop|restart"
        ;;
esac

