<?php

/*
 +-----------------------------------------------------------------------+
 | program/steps/settings/edit_identity.inc                              |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2007, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Show edit form for a identity record or to add a new one            |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: edit_extaccount.inc,v 1.4 2011-04-11 08:23:47 chihcheng Exp $

*/

define('IDENTITIES_LEVEL', intval($RCMAIL->config->get('identities_level', 0)));
$init_status= array('add-extaccount');
$add_status = array('add-extaccount', 'add-extaccount_a','add-extaccount_b', 'add-extaccount_c','add-extaccount_d');
$all_cols = array('ext', 'email', 'extusername', 'extpd', 'popserver', 'popport', 'select_folder', 'select_smtp',
              'new_folder','fetch_days','use_newfolder', 'remove_mail', 'fetchpass', 'addsmtp', 
              'smtpport', 'smtpuser', 'smtppass', 'ifssl', 'iftls', 'ifdefault', 'smtpdesc', 'smtpserver');
$a_identity_cols = array('email', 'ext', 'extusername', 'extpd', 'popserver', 'popport', 'ifssl', 'select_folder', 
                   'remove_mail', 'select_smtp'); 


// edit-extaccount
if (($_GET['_iid'] || $_POST['_iid'] ) && !in_array($RCMAIL->action,$add_status)) {
  $ACCOUNT_RECORD = $USER->get_identity(get_input_value('_iid', RCUBE_INPUT_GPC));
  foreach($a_identity_cols as $col)
    $_SESSION[$col] = $ACCOUNT_RECORD[$col];
  if (is_array($ACCOUNT_RECORD))
    $OUTPUT->set_env('iid', $ACCOUNT_RECORD['identity_id']);
  else {
    $OUTPUT->show_message('opnotpermitted', 'error');
    $OUTPUT->send('watermark');
  }
}
// add-extaccount
else {
  if (in_array($RCMAIL->action, $init_status)) {
    rcmail_clean_session();
    rcmail_init_session();
  }
  //read from session
  foreach ($all_cols as $col) {
    if (isset($_SESSION[$col])) {
      $ACCOUNT_RECORD[$col] = $_SESSION[$col];
    }
  }
  if (IDENTITIES_LEVEL > 1) {
    $OUTPUT->show_message('opnotpermitted', 'error');
    rcmail_overwrite_action('extmail');
  }
  else if (IDENTITIES_LEVEL == 1) {
    $ACCOUNT_RECORD['email'] = $RCMAIL->user->get_username();
  }
  
}



function rcube_extaccount_tip($str='')
{
  $tips = new html_table();
  if (strstr($str,'step')) {
    $tips->add(null,rcube_label($str));
  } else {
    $tips->add('title', sprintf('<label for="%s">%s</label>', $str, rcube_label($str)));
  }
  return $tips->show(); 
}

function rcube_extaccount_form($attrib)
{
  global $ACCOUNT_RECORD, $RCMAIL, $OUTPUT, $IMAP;

  $OUTPUT->add_label('no_attachmentsize', 'no_ext_password', 'no_ext_username', 'no_pop_port', 'no_pop_server');
  $OUTPUT->add_label('no_folder', 'no_smtpport', 'no_smtpserver', 'error_fetch_days','forbiddencharacter');
  $OUTPUT->add_label('checking');

  // Get basic form and history record
  list($form,$ACCOUNT_RECORD)=rcmail_extaccount($attrib);

  // Set form tags and hidden fields
  list($form_start, $form_end) = get_form_tags($attrib, 'save-extaccount',
    intval($ACCOUNT_RECORD['identity_id']),
    array('name' => '_iid', 'value' => $ACCOUNT_RECORD['identity_id']));
  $step=rcmail_current_step();
  $OUTPUT->set_env('extaccount_step', $step);
 $OUTPUT->set_env('delimiter', $IMAP->get_hierarchy_delimiter());

  unset($plugin);
  unset($attrib['form']);

  // layout configure
  $add_status = array('add-extaccount', 'add-extaccount_a', 'add-extaccount_b', 'add-extaccount_c', 'add-extaccount_d');
  $front = array('ifssl', 'retain_mail', 'remove_mail', 'use_current', 'use_newfolder', 'fetch_recently', 
             'fetch_days', 'fetch_new','fetch_all','use_default_smtp', 'addsmtp', 'iftls', 'ifdefault'
           );     
  $back  = array('email', 'username', 'password', 'popserver','popport','select_smtp','select_folder', 'new_folder',
             'smtpdesc', 'smtpserver', 'smtpport','smtppass','smtpuser'
           );
  $notitle = array('select_folder', 'new_folder','select_smtp');
  $skip = array('use_newfolder','new_folder');
  $blockquote = array('qtwo');

  // layout to xtml
  $fieldset=$form[$step]; 
  $out = "$form_start\n";
  $savetoggle = new html_hiddenfield(array('name' => '_save', 'value' => ''));
  $out .= $savetoggle->show();

  if (in_array($RCMAIL->action,$add_status))
    $out .= rcube_extaccount_tip($fieldset['name']); 
  $content = '';      
  foreach ($fieldset['content'] as $option =>$options) { 
    if ($option=='select_smtp' && in_array($RCMAIL->action,$add_status))
      continue;
    
    $content .= (in_array($option, $blockquote))?'<blockquote>':'';
    $content = ($step=='steptwo')?rcube_extaccount_tip($option):$content;
    $content = ($step=='stepfour')?rcube_extaccount_tip($option):$content;

    $table = new html_table(array('cols' => rcube_layout_cols($option)));
    foreach ($options as $col => $colprop) {
      if ( !in_array($RCMAIL->action,$add_status) && in_array($col, $skip))
        continue;
      if (in_array($col, $front))
        $table->add(null,$colprop);
      if (!in_array($col, $notitle))
        $table->add('title', sprintf('<label for="%s">%s</label>', 'rcmfd_'.$col, Q(rcube_label($col))));
      if (in_array($col, $back))
        $table->add(null,$colprop);
      if ($col == 'fetch_all')
        $table->add_row();
    }
    $content .= $table->show();
    $content .= ($step=='steptwo')?'<br />':'';
    
    $out .= ($step=='steptwo')? html::tag('fieldset', null, $content):'';
    $out .= ($step=='stepfour')?html::tag('fieldset', null, $content):'';
  }
  $out .= ($step=='stepone')?html::tag('fieldset', null, $content) ."\n":'';
  $out .= ($step=='stepthree')?html::tag('fieldset', null, $content) ."\n":'';
  $out .= $form_end;
 
  return $out;

}
function rcube_layout_cols($prompt='')
{
  $colsarray = array('where_to_place'=>3,'qone'=>3, 'days_to_fetch'=>4); 
  return intval(isset($colsarray[$prompt])?$colsarray[$prompt]:2);
}
$OUTPUT->include_script('list.js');
$OUTPUT->add_handler('extaccountform', 'rcube_extaccount_form');
$OUTPUT->set_env('identities_level', IDENTITIES_LEVEL);

$OUTPUT->set_pagetitle(rcube_label((in_array($RCMAIL->action,$add_status) ? 'new_account' : 'edititem')));
$OUTPUT->send(in_array($RCMAIL->action,$add_status)?'extmailadd':'extmailedit');



