<?php
/*
 +-----------------------------------------------------------------------+
 | program/steps/settings/save_identity.inc                              |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2009, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Save an identity record or to add a new one                         |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: save_admin.inc,v 1.7 2011-02-21 10:27:12 chihcheng Exp $

*/
$CURR_SECTION = get_input_value('_section', RCUBE_INPUT_POST);

global $RCMAIL,$CONFIG,$USER;
$config = $RCMAIL->config;
$record = $CONFIG;

// check input
switch($CURR_SECTION)
{
  case 'smtp':
    $a_save_cols = array('smtp_server', 'smtp_port', 'attachment_size');
    $a_boolean_cols = array();
	$updated = $default_id = false;

    if ((empty($_POST['_smtp_server'])) || (empty($_POST['_smtp_port'])) ||
         (empty($_POST['_attachment_size'])) 
         ) {
      $OUTPUT->show_message('formincomplete', 'warning');
      rcmail_overwrite_action('edit-admin');
      return;
    }

    if (!is_numeric($_POST['_attachment_size'])) {
      $OUTPUT->show_message('no_attachmentsize', 'warning');
      rcmail_overwrite_action('edit-admin');
      return;
    }

    $attachment_limit = preg_replace ("/M/s",'',ini_get('post_max_size'));

    if ($_POST['_smtp_server']=='localhost' && ($message_size_limit = $config->paser_max_messages_size()))
       $attachment_limit = ($attachment_limit < $message_size_limit)?$attachment_limit:$message_size_limit;
    if ($attachment_limit < $_POST['_attachment_size']) {
      $OUTPUT->show_message('bound_attachment_limit', 'warning',array('num' => show_bytes($attachment_limit * 1048576)));
      rcmail_overwrite_action('edit-admin');
      return;
    } 

  break;
  case 'extmail':    
    $a_save_cols = array('extmailallow', 'extmailperiod');
    $a_boolean_cols = array('extmailallow');
    $updated = $default_id = false;

  break; 
  default:
  break;
}
$save_data = array();
foreach ($a_save_cols as $col)
{
  $fname = '_'.$col;
  if (isset($_POST[$fname]))
    $save_data[$col] = get_input_value($fname, RCUBE_INPUT_POST);
}

// set "off" values for checkboxes that were not checked, and therefore
// not included in the POST body.
foreach ($a_boolean_cols as $col)
{
  $fname = '_' . $col;
  if (!isset($_POST[$fname]))
    $save_data[$col] = 0;
  else
    $save_data[$col] = 1;
}
$rcflag = false;
$smtp_changed=false;
// overwrite data
foreach ($save_data as $col => $colprop)
{
  $filepath='';
  if ($colprop != $record[$col]) {
    if($col=='smtp_server' || $col=='smtp_port') {
        $smtp_changed=true;
    }
    $newvalue = ($col=='smtp_server')?$colprop:preg_replace("/^0*/i",'',$colprop);
    $oldvalue = $record[$col];
    switch ($col) {
      case 'extmailallow':
        if (!$oldvalue && $newvalue)
           $rcflag = true;
		$newvalue = ($colprop == '1') ? "true" : "false";
        $oldvalue = ($oldvalue) ? "true" : "false";
		if ($oldvalue=="true" && $newvalue=="false")
          rcmail_daemon_stop();   
		if ($oldvalue=="false" && $newvalue=="true")
          rcmail_daemon_start();
        $filepath = RCMAIL_CONFIG_DIR . '/main.inc.php';
        break;
      case 'smtp_port':
      case 'smtp_server':
        $filepath = RCMAIL_CONFIG_DIR . '/main.inc.php';
        break;
      case 'extmailperiod':
        $userlist = $USER->list_users();
        foreach ($userlist as $user) {
            $fetchtemp = RCMAIL_EXT_DIR . '/'.$user['username'].'_fetch';
            if (!file_exists($fetchtemp)) {
              continue;
            }

        	$cmd = RCMAIL_FETCH_EXEC . ' ' . escapeshellarg($user['username']) . ' 1'; 
			system($cmd);
            if ($config->writedata('daemon',60*$newvalue,60*$oldvalue,$fetchtemp)) {
              $OUTPUT->show_message('formincomplete', 'warning');
            }
        	$cmd = RCMAIL_FETCH_EXEC . ' ' . escapeshellarg($user['username']) . ' 2'; 
			system($cmd);
        }
        $fetchtemp = RCMAIL_EXT_DIR . '/fetchmailrc';

        if ($config->writedata('daemon',60*$newvalue,60*$oldvalue,$fetchtemp)) {
          $OUTPUT->show_message('formincomplete', 'warning');
          rcmail_overwrite_action('edit-admin');
          return;
        }
        $filepath = RCMAIL_CONFIG_DIR . '/main.inc.php';
        break;
      case 'attachment_size':
        $filepath = INSTALL_PATH . '.htaccess';
        break;
      default:
        break;
     }
     if ($config->writedata($col,$newvalue,$oldvalue,$filepath)) {
       $OUTPUT->show_message('formincomplete', 'warning');
       rcmail_overwrite_action('edit-admin');
       return;
     }
     $CONFIG[$col] = $colprop;
  }
}

if ($smtp_changed) {
  $cmd = RCMAIL_FETCH_EXEC . ' ' .$save_data['smtp_server'] .':'.preg_replace("/^0*/i",'',$save_data['smtp_port']) . ' 3'; 
  system($cmd);
}
// if allow extermail recvive, then download certification
if ($rcflag) {

}
$OUTPUT->show_message('successfullysaved', 'confirmation');

// display the form again
rcmail_overwrite_action('edit-admin');
