<?php

/*
 +-----------------------------------------------------------------------+
 | program/steps/settings/save_identity.inc                              |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2009, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Save an identity record or to add a new one                         |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: save_extaccount.inc,v 1.4 2011-04-11 08:23:47 chihcheng Exp $

*/

define('IDENTITIES_LEVEL', intval($RCMAIL->config->get('identities_level', 0)));

$a_reveal_cols = array('email', 'extusername', 'extpd', 'popserver', 'popport', 'select_folder', 'new_folder',
                 'fetch_days','use_newfolder', 'remove_mail', 'fetchpass','ifssl', 'select_smtp',
                 'addsmtp', 'smtpport', 'smtpuser', 'smtppass', 'iftls','ifdefault','smtpdesc', 'smtpserver', 'save'
);
$a_save_cols = array('ext','email', 'extusername', 'extpd', 'popserver', 'popport', 'select_folder',
                  'remove_mail', 'ifssl', 'select_smtp','ca_failure'
);
$a_smtp_cols= array('smtpport', 'smtpuser', 'smtppass','iftls','ifdefault','smtpdesc', 'smtpserver');

$a_boolean_cols =array('_email'=>array('ifssl'),'_addsmtp'=>array('iftls', 'ifdefault'),'_select_folder'=>array('remove_mail'));

$updated = $default_id = false;
$save_data = array();
$save_data_smtp = array();
foreach ($a_reveal_cols as $col)
{
  $fname = '_'.$col;
  if (isset($_POST[$fname])) {
    $_SESSION[$col]  = get_input_value($fname, RCUBE_INPUT_POST);
    if ($col == 'extusername' && !isset($_SESSION['smtpuser']))
      $_SESSION['smtpuser'] = $_SESSION[$col];
  }
    
	
}

// set "off" values for checkboxes that were not checked, and therefore
// not included in the POST body.Related col just to ensure we now at correct step
foreach ($a_boolean_cols as $related_col => $cols)
{
  foreach ($cols as $col) {
    $fname = '_'.$col;
    if (!isset($_POST[$fname]) && isset($_POST[$related_col])){
      $_SESSION[$col] = 0;
    } else if (isset($_POST[$fname])){
      $_SESSION[$col] = 1;
    }
  }
}

//cancel case
if ($_SESSION['save'] == 'cancel')
{
  rcmail_clean_session();
  $OUTPUT->send('watermark');
  return;
}

//duplicate email
if (($_SESSION['save']=='add-extaccount_b') && $USER->get_identity_by_email($_SESSION['email'])) 
{
  $OUTPUT->show_message('emailduplicate', 'error', array('email' => $_SESSION['email']));
  rcmail_overwrite_action('add-extaccount_a');
  return;
}

//connect and CA certification test
if ( $_SESSION['save']=='add-extaccount_b' && $_POST['_popserver']) 
{
  if ($err = $USER->popserver_connect_test($_SESSION['popserver'],$_SESSION['popport'])) {
    $OUTPUT->show_message('connerror', 'error', array('code' => $err));
  	rcmail_overwrite_action('add-extaccount_a');
  	return;
  }

  if (isset($_POST['_ifssl']) && $USER->ca_failure_test($_SESSION['popserver'],$_SESSION['popport'])) {
	$_SESSION['ca_failure'] = 1;
  }
}


// unset email address if user has no rights to change it
if (IDENTITIES_LEVEL == 1 || IDENTITIES_LEVEL == 3)
  unset($save_data['email']);

// specical case for clean SESSION
if ($_SESSION['addsmtp'] == 0) 
  foreach ($a_smtp_cols as $col)
    unset($_SESSION[$col]);

// update an existing external account
if ($_POST['_iid'])
{
  //save account cols
  foreach ($a_save_cols as $col)
    $save_data[$col] = $_SESSION[$col];

  $iid = get_input_value('_iid', RCUBE_INPUT_POST);

  $save_data['ca_failure'] = $USER->ca_failure_test($save_data['popserver'],$save_data['popport']) ? 1 : 0;
  if (!$USER->writerc($save_data,'-1',$iid)) {
    $OUTPUT->show_message('errorsaving', 'error', null, false);
    return;
  }
  unset($save_data['ca_failure']);
  if ($updated = $USER->update_identity($iid, $save_data))
  {
    $OUTPUT->show_message('successfullysaved', 'confirmation');
    
    if (!empty($_POST['_standard']))
      $default_id = get_input_value('_iid', RCUBE_INPUT_POST);
  }
  else if ($DB->is_error())
  {
    $OUTPUT->show_message('errorsaving', 'error', null, false);
  }
  $OUTPUT->send('watermark');
}
//save create extaccount data
else if (!empty($_POST['_save']) && ($_SESSION['save'] == '1')) {
  //handle select folder if new one
  if ($_SESSION['use_newfolder'] == 1) {
    $_SESSION['select_folder'] = rcmail_create_folder($_SESSION['new_folder']);
  } 
  unset($_SESSION['use_newfolder']);
  unset($_SESSION['new_folder']);

  //save cols of session, identity and smtp
  foreach ($a_save_cols as $col){
    $save_data[$col] = $_SESSION[$col];
    unset($_SESSION[$col]);
  }
    

  $save_data['name'] = strstr($save_data['email'], '@', true); 
  if (IDENTITIES_LEVEL == 1)
    $save_data['email'] = $RCMAIL->user->get_username();

  //save new smtp data
  if (($_SESSION['addsmtp'] == 1))
  {
    foreach ($a_smtp_cols as $col){
      $save_data_smtp[$col] = $_SESSION[$col];
      unset($_SESSION[$col]);
    }


    if ($save_data_smtp['smtpserver'] && $save_data_smtp['smtpport'])
    {
      $sid = $USER->insert_smtp($save_data_smtp);
      $save_data['select_smtp'] = $sid;
    }
    else
    {
      $OUTPUT->show_message('errorsaving', 'error', null, false);
      goto end;
    }

    if ($save_data_smtp['ifdefault'] == 1) 
    {
      $USER->set_default_smtp($sid);
    }
  }
  unset($_SESSION['addsmtp']);

  $fetchpass = get_input_value('_fetchpass', RCUBE_INPUT_POST); 
  $fetchdays = ($fetchpass==1)?-1:0;
  $fetchdays = ($fetchpass==0)?get_input_value('_fetch_days', RCUBE_INPUT_POST):$fetchdays;

  //save new identity
  if (!$USER->writerc($save_data, $fetchdays,'')) {
    $OUTPUT->show_message('errorsaving', 'error', null, false);
    goto end;

  }
  unset($save_data['ca_failure']);
  if ($insert_id = $USER->insert_identity($save_data)) {
    
    $_GET['_iid'] = $insert_id;

    if (!empty($_POST['_standard']))
      $default_id = $insert_id;
  }
  else
  {
    $OUTPUT->show_message('errorsaving', 'error', null, false);
    goto end;
  }

  $OUTPUT->show_message('successfullysaved', 'confirmation', null, false);
end:
  $OUTPUT->send('watermark');
} 
//non-save
else {
    if (!empty($_POST['_save']))
      rcmail_overwrite_action($_SESSION['save']);
}

// mark all other identities as 'not-default'
if ($default_id)
  $USER->set_default($default_id);

// go to next step
//rcmail_overwrite_action('add-extaccount');

function rcmail_create_folder($name){
  global $RCMAIL, $IMAP, $OUTPUT;
  $RCMAIL->imap_connect();
  if (!$IMAP->create_mailbox($name, TRUE))
    $name = '';
  return $name;
}

