<?php

/*
 +-----------------------------------------------------------------------+
 | program/steps/admin/func.inc                                       |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2007, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Provide functionality for user's settings & preferences             |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: func.inc,v 1.3 2011-02-25 09:37:23 chihcheng Exp $

*/

if (!$OUTPUT->ajax_call)
  $OUTPUT->set_pagetitle(rcube_label('adminsettings'));

// register UI objects
$OUTPUT->add_handlers(array(
  'adminframe' => 'rcmail_admin_frame',
  'adminlist' => 'rcmail_admin_list',
));
// similar function as /steps/settings/identities.inc::rcmail_identity_frame()
function rcmail_admin_frame($attrib)
{
  global $OUTPUT;

  if (!$attrib['id'])
    $attrib['id'] = 'rcmadminframe';

  $attrib['name'] = $attrib['id'];

  $OUTPUT->set_env('contentframe', $attrib['name']);
  $OUTPUT->set_env('blankpage', $attrib['src'] ? $OUTPUT->abs_url($attrib['src']) : 'program/blank.gif');

  return html::iframe($attrib);
}

function rcmail_daemon_stop()
{
  global $USER;
  $cmd = '';
  $userlist = $USER->list_users();
  foreach ($userlist as $user) {
        $cmd = RCMAIL_FETCH_EXEC . ' ' . escapeshellarg($user['username']) . ' -2'; 
		$buffer = system($cmd);
 }
  return true;
}
function rcmail_daemon_start()
{
  global $USER;
  $cmd = '';
  $userlist = $USER->list_users();
  foreach ($userlist as $user) {
        $cmd = RCMAIL_FETCH_EXEC . ' ' . escapeshellarg($user['username']) . ' -1'; 
		$buffer = system($cmd);
 }
  return true;
}

function rcmail_admin_list($attrib)
{
  global $RCMAIL;

  // add id to message list table if not specified
  if (!strlen($attrib['id']))
    $attrib['id'] = 'rcmadminlist';

  list($list, $cols) = rcmail_admin();

  // create XHTML table
  $out = rcube_table_output($attrib, $list, $cols, 'id');

  // set client env
  $RCMAIL->output->add_gui_object('adminlist', $attrib['id']);
  $RCMAIL->output->include_script('list.js');

  return $out;
}




// similar function as in /steps/addressbook/edit.inc
function get_form_tags($attrib, $action, $id = null, $hidden = null)
{
  global $EDIT_FORM, $RCMAIL;

  $form_start = $form_end = '';

  if (empty($EDIT_FORM)) {
    $request_key = $action . (isset($id) ? '.'.$id : '');
    $form_start = $RCMAIL->output->request_form(array(
	  'name'    => 'form',
	  'method'  => 'post',
	  'task'    => $RCMAIL->task,
	  'action'  => $action,
	  'request' => $request_key,
	  'noclose' => true
	) + $attrib);

    if (is_array($hidden)) {
      $hiddenfields = new html_hiddenfield($hidden);
      $form_start .= $hiddenfields->show();
    }

    $form_end = !strlen($attrib['form']) ? '</form>' : '';

    $EDIT_FORM = !empty($attrib['form']) ? $attrib['form'] : 'form';
    $RCMAIL->output->add_gui_object('editform', $EDIT_FORM);
  }

  return array($form_start, $form_end);
}


function rcmail_admin($current=null)
{
  global $RCMAIL,$CONFIG;

  $admin['smtp'] = array('id' => 'smtp',  'section' => rcube_label('presmtpsettings'));
  $admin['extmail'] = array('id' => 'extmail',  'section' => rcube_label('extmail_settings'));
  $plugin =  array('list' => $admin, 'cols' => array('section'));
  $config = $RCMAIL->config->all();
  foreach ($admin as $idx => $sect) {

    if ($current && $sect['id'] != $current)
      continue;

    $blocks = array();

    switch ($sect['id']) {
    // general

    // Smtp settings
    case 'smtp':

      $blocks = array(
        'smtpsettings' => array('name' => Q(rcube_label('presmtpsettings'))),
      );
      $blocks['smtpsettings']['descr'] = html::label($field_id, Q(rcube_label('descr_predefined_smtpsetting')));

      $field_id = 'rcmfd_smtp_server';
      $blocks['smtpsettings']['options']['smtp_server'] = array(
        'title' => html::label($field_id, Q(rcube_label('smtpserver'))),
        'content' => array('id' => $field_id, 'type' => 'text','size' => '40' ),
      );

      $field_id = 'rcmfd_smtp_port';
      $blocks['smtpsettings']['options']['smtp_port'] = array(
        'title' => html::label($field_id, Q(rcube_label('smtpport'))),
        'content' => array('id' => $field_id, 'type' => 'text','size' => '40' ),
      );

      $field_id = 'rcmfd_attachment_size';
      $blocks['smtpsettings']['options']['attachment_size'] = array(
        'title' => html::label($field_id, Q(rcube_label('attachmentsize'))),
        'content' => array('id' => $field_id, 'type' => 'text','size' => '40' ),
      );
    break;

    // Extenal mail settings
    case 'extmail':

      $blocks = array(
        'extmailsettings' => array('name' => Q(rcube_label('extmail_settings'))),
      );

      $field_id = 'rcmfd_extmailallow';
      $blocks['extmailsettings']['options']['extmailallow'] = array(
        'title' => html::label($field_id, Q(rcube_label('extmail_allow'))),
        'content'=> array('type' => 'checkbox', 'label' => rcube_label('extmail_allow'),
          'checked'   => "checked",
          'onclick'   => "document.getElementById('rcmfd_extmailperiod').disabled=this.checked==false"),
      );

      $field_id = 'rcmfd_extmailperiod';
      $blocks['extmailsettings']['options']['extmailperiod'] = array(
        'title' => html::label($field_id, Q(rcube_label('extmail_period'))),
        'content' => array('id' => $field_id, 'type' => 'text',
          'disabled' => ($CONFIG['extmailallow']!='1'), 'size' => '6',
          'onkeydown' => "if (event.keyCode == 13) return rcmail.command('save','',this)"),
      );

    break;
    }

    $data = array('section' => $sect['id'], 'blocks' => $blocks);
    $found = false;

    // create output
    foreach ($data['blocks'] as $block) {
      if (!empty($block['content']) || !empty($block['options'])) {
        $found = true;
	    break;
      }
    }

    if (!$found)
      unset($admin[$idx]);
    else
      $admin[$idx]['blocks'] = $data['blocks'];
  }

  return array($admin, $plugin['cols']);
}

