<?php

/*
 +-----------------------------------------------------------------------+
 | program/localization/index.inc                                        |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2009, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Provide a centralized location table                                |
 |   for keeping track of available languages                            |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: index.inc,v 1.1 2010-12-30 12:22:25 chihcheng Exp $

*/

// langage codes according to ISO 639-1
// country codes according to ISO 3166-1 (Alpha-2)
// original names from http://www.mediaglyphs.org/mg/p/langnames.html

$rcube_languages = array(
   'zh_CN' => 'Chinese (简体中文)',
   'zh_TW' => 'Chinese (正體中文)',
   'cs_CZ' => 'Czech (Česky)',
   'da_DK' => 'Danish (Dansk)',
   'de_DE' => 'Deutsch (Deutsch)',
   'nl_NL' => 'Dutch (Nederlands)',
   'en_US' => 'English (US)',
   'fr_FR' => 'French (Français)',
   'hu_HU' => 'Hungarian (Magyar)',
   'it_IT' => 'Italian (Italiano)',
   'ja_JP' => 'Japanese (日本語)',
   'ko_KR' => 'Korean (한국어)',
   'nb_NO' => 'Norwegian (Bokmål)',
   'pl_PL' => 'Polish (Polski)',
   'pt_BR' => 'Portuguese (Brasil)',
   'pt_PT' => 'Portuguese (Português)',
   'ru_RU' => 'Russian (Русский)',
   'es_AR' => 'Spanish (Argentina)',
   'sv_SE' => 'Swedish (Svenska)',
   'tr_TR' => 'Turkish (Türkçe)',
);

$rcube_language_aliases = array(
  'cn' => 'zh_CN',
  'cs' => 'cs_CZ',
  'cz' => 'cs_CZ',
  'da' => 'da_DK',
  'de' => 'de_DE',
  'en' => 'en_US',
  'ja' => 'ja_JP',
  'ko' => 'ko_KR',
  'kr' => 'ko_KR',
  'pl' => 'pl_PL',
  'tw' => 'zh_TW',
  'se' => 'sv_SE',
  'sv' => 'sv_SE',
  'zh' => 'zh_TW',
);

?>
