<?php

/*
 +-----------------------------------------------------------------------+
 | program/steps/settings/identities.inc                                 |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2007, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Manage identities of a user account                                 |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: extmail.inc,v 1.3 2011-01-24 08:45:27 chihcheng Exp $

*/

define('IDENTITIES_LEVEL', intval($RCMAIL->config->get('identities_level', 0)));

$OUTPUT->set_pagetitle(rcube_label('extmail'));

$OUTPUT->include_script('list.js');
function rcmail_extmail_frame($attrib)
{
  global $OUTPUT;

  rcmail_clean_session();
  if (!$attrib['id'])
    $attrib['id'] = 'rcmextmailframe';

  $attrib['name'] = $attrib['id'];

  $OUTPUT->set_env('contentframe', $attrib['name']);
  $OUTPUT->set_env('blankpage', $attrib['src'] ? $OUTPUT->abs_url($attrib['src']) : 'program/blank.gif');

  return html::iframe($attrib);
}

$OUTPUT->set_env('identities_level', IDENTITIES_LEVEL);
$OUTPUT->add_handler('extmailframe','rcmail_extmail_frame');
$OUTPUT->send('extmail');
