<?php

/*
 +-----------------------------------------------------------------------+
 | program/steps/settings/delete_prefs.inc                               |
 |                                                                       |
 | This file is part of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2009, Roundcube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Delete the submitted smtp (SIDs) from the database                  |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: delete_prefs.inc,v 1.3 2011-01-24 08:45:27 chihcheng Exp $

*/

$sid = get_input_value('_sid', RCUBE_INPUT_GPC);
$action = ($RCMAIL->action=='delete-prefs')?true:false;
// check request token
if (!$OUTPUT->ajax_call && !$RCMAIL->check_request(RCUBE_INPUT_GPC)) {
  $OUTPUT->show_message('invalidrequest', 'error');
  if($action)
    rcmail_overwrite_action('');
  return;
}

if ($sid && preg_match('/^[0-9]+(,[0-9]+)*$/', $sid))
{
  
  if ($USER->delete_smtp($sid)) {
    unset( $_GET['_sid']);
    $OUTPUT->show_message('deletedsuccessfully', 'confirmation', null, true);
  }
  else {
    $OUTPUT->show_message('nodeletelastidentity', 'error', null, true);
  }
  // send response
  if ($OUTPUT->ajax_call)
    $OUTPUT->send();
}

if ($OUTPUT->ajax_call)
  exit;

// go to preferens page
if($action)
  rcmail_overwrite_action('edit-prefs');


