<?php

if (!$OUTPUT->ajax_call)
  $OUTPUT->set_pagetitle(rcube_label('adminsettings'));
$OUTPUT->add_handlers(array(
  'adminsettingsform' => 'rcmail_admin_settings_form',
  'adminsectionname' => 'rcmail_admin_section_name',
));

$CURR_SECTION = get_input_value('_section', RCUBE_INPUT_GPC);
list($SECTIONS,) = rcmail_admin($CURR_SECTION);
// register UI objects
function rcmail_admin_settings_form($attrib)
{
  global $RCMAIL, $CURR_SECTION, $SECTIONS,$CONFIG;

  // add some labels to client
  $RCMAIL->output->add_label('no_smtpserver','no_smtpport','no_attachmentsize','no_extmail_period');

  unset($attrib['form']);

  list($form_start, $form_end) = get_form_tags($attrib, 'save-admin', null,
    array('name' => '_section', 'value' => $CURR_SECTION));

  $out = $form_start;

  foreach ($SECTIONS[$CURR_SECTION]['blocks'] as $idx => $block) {
    if (!empty($block['options'])) {
      $table = new html_table(array('cols' => 2));

      foreach ($block['options'] as $col => $option) {
        if ($option['advanced'])
	      $table->set_row_attribs('advanced');

        $table->add('title', $option['title']);
        $colprop = $option['content'];
        $value = !empty($colprop['value']) ? $colprop['value'] :
            rcmail_get_edit_field($col, $CONFIG[$col], $colprop, $colprop['type']);
        $table->add(null, $value);
        
	   // $table->add(null, $option['content']);
      }

      $out .= html::tag('fieldset', null, html::tag('legend', null, $block['name']) .$block['descr']. $table->show($attrib));
    }
    else if (!empty($block['content'])) {
      $out .= html::tag('fieldset', null, html::tag('legend', null, $block['name']) . $block['content']);
    }
  }

  return $out . $form_end;

}

function rcmail_admin_section_name()
{
  global $SECTIONS, $CURR_SECTION;
  return $SECTIONS[$CURR_SECTION]['section'];
}
$OUTPUT->send('adminedit');

