#!/bin/sh

. /var/packages/MailServer/target/scripts/MailServerCommon

HOOK_DIR="/var/packages/MailServer/target/hook"
DIR_SRV_HOOK="${HOOK_DIR}/dir_service_hook"

PIDFILE_SYNO_MAILSERVERD="/var/run/syno_mailserverd.pid"
BIN_SYNO_MAILSERVERD="/var/packages/MailServer/target/sbin/syno_mailserverd"

case $1 in
	--sdk-mod-ver)
		${DIR_SRV_HOOK} --sdk-mod-ver;
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--pre)
		;;
	--post)
		#check result of refresh
		if [ "0" != ${RESULT} ]; then
			exit 0;
		fi

		#check pid file
		if [ ! -f "$PIDFILE_SYNO_MAILSERVERD" ]; then
			logger -p 0 "pid file of syno_mailserverd does not existed, restart"
			${BIN_SYNO_MAILSERVERD}
		fi

		PROCESS_PID=`cat $PIDFILE_SYNO_MAILSERVERD`

		#check daemon status
		kill -0 ${PROCESS_PID}
		if [ "0" != "$?" ]; then
			logger -p 0 "syno_mailserverd does not run, restart"
			${BIN_SYNO_MAILSERVERD}
			PROCESS_PID=`cat $PIDFILE_SYNO_MAILSERVERD`
		fi

		# Send HUP to rebuild alias db
		kill -HUP ${PROCESS_PID}
		;;
	*)
	;;
esac
