#!/bin/sh

SASLAUTHD=/var/packages/MailServer/target/sbin/saslauthd
POSTFIX=/var/packages/MailServer/target/sbin/postfix

PackagePath="/var/packages/MailServer"
MailServerConf="$PackagePath/etc/mailserver.conf"

LogDaemon=/var/packages/MailServer/target/sbin/syno_mailloggerd
LogDaemonPID=/var/run/syno_mailloggerd.pid

start() {
	echo "Starting Maillog Daemon..."
	${LogDaemon}

	echo "Starting SASLAuthd..."
	$SASLAUTHD -a pam

	echo "Starting Postfix..."
	$POSTFIX start
}

stop() {
	saslauthd_pid=/var/run/saslauthd/saslauthd.pid
	if [ -f $saslauthd_pid ]; then
		echo "Stopping SASLAuthd..."
		kill `cat $saslauthd_pid`
	fi
	echo "Stopping Postfix..."
	$POSTFIX stop

    echo "Stop Log Daemon..."
    kill `cat ${LogDaemonPID}`
}

restart() {

	echo "Reload Postfix..."
	$POSTFIX reload
}

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		restart
		;;
	*)
		echo "Usage: $0 {start|stop|reload}" >&2
		exit 1
		;;
esac

exit 0
