#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOUserSet()
#	Usable environment variable:
#		NITEMS, ORIGIN_USER_NAME_{n}, USER_NAME_{n}, UID_{n},
#		USER_OP_RESULT_{n}, RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################
case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		version=`/var/packages/MailServer/target/hook/AliasUserUpdate.sh --sdk-mod-ver`
		echo "$version";
		;;
	--name)
		#Print package name
		name=`/var/packages/MailServer/target/hook/AliasUserUpdate.sh --name`
		echo "$name";
		;;
	--pkg-ver)
		#Print package version
		pkg_ver=`/var/packages/MailServer/target/hook/AliasUserUpdate.sh --pkg-ver`
		echo "$pkg_ver";
		;;
	--vendor)
		#Print package vendor
		vendor=`/var/packages/MailServer/target/hook/AliasUserUpdate.sh --vendor`
		echo "$vendor";
		;;
	--pre)
		/var/packages/MailServer/target/hook/AliasUserUpdate.sh --pre &
		;;
	--post)
		/var/packages/MailServer/target/hook/AliasUserUpdate.sh --post &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
