#!/bin/sh
PackagePath="/var/packages/MailServer"
#config template
PostfixTemplate="$PackagePath/target/etc/template/main.template"
DevecotTemplate="$PackagePath/target/etc/template/dovecot.template"
AliasTemplate="$PackagePath/target/etc/template/aliases.template"
MasterTemplate="$PackagePath/target/etc/template/master.template"
SpamassassinTemplate="$PackagePath/target/etc/template/spamassassin.template"
MailScannerTemplate="$PackagePath/target/etc/template/mailscanner.template"

#smtp
MailServerConf="$PackagePath/etc/mailserver.conf"
PostfixConf="/var/packages/MailServer/target/etc/main.cf"
SetRelayAuth=$PackagePath/target/bin/syno_set_relay_auth
LoginMap="/var/packages/MailServer/target/etc/login_map"
GenConfValue=$PackagePath/target/bin/syno_gen_conf_value
PAM_UNIX_SRC="$PackagePath/target/etc/pam.d/pam.unix"
PAM_UNIX_BLOCK_SRC="$PackagePath/target/etc/pam.d/pam_block.unix"
PAM_WIN_SRC="$PackagePath/target/etc/pam.d/pam.win"
PAM_WIN_BLOCK_SRC="$PackagePath/target/etc/pam.d/pam_block.win"
PAM_LDAP_SRC="$PackagePath/target/etc/pam.d/pam.ldap"
PAM_LDAP_BLOCK_SRC="$PackagePath/target/etc/pam.d/pam_block.ldap"
PAM_SMTP_LINK="/etc/pam.d/smtp"
PAM_DOVECOT_LINK="/etc/pam.d/dovecot"

#alias
AliasDB="$PackagePath/etc/alias.db"
Table="alias_info_table"
AliasConf="/var/packages/MailServer/target/etc/aliases" #need modify after package location done
GroupTable="/etc/group"
PostAlias=/var/packages/MailServer/target/sbin/postalias
#protocol
DovecotConf="/var/packages/MailServer/target/etc/dovecot.conf"

#spam filter
MasterConf="/var/packages/MailServer/target/etc/master.cf"
SpamassassinConf="/var/packages/MailServer/target/etc/spamassassin/local.cf"
MailScannerConf="/var/packages/MailServer/target/etc/MailScanner/MailScanner.conf"

# save all user string
ALL_USERS=""

# get ipv4only
IPV4=`/bin/get_key_value /etc.defaults/synoinfo.conf ipv4only`

# get account type
AccountType=`/bin/get_key_value $MailServerConf account_type`

# get DSM version
DSM_Major=`/bin/get_key_value /etc.defaults/VERSION majorversion`
DSM_Minor=`/bin/get_key_value /etc.defaults/VERSION minorversion`

# check DSM is support auto block PAM
HaveAutoBlockPam()
{
	if [ "$DSM_Major" -lt 4 ]; then
		return 0;
	elif [ "$DSM_Major" -eq 4 ] && [ "$DSM_Minor" -lt 2 ]; then
		return 0;
	fi
	return 1;
}

CreatePamLink()
{
	rm -rf ${PAM_SMTP_LINK}
	rm -rf ${PAM_DOVECOT_LINK}
	if [ "$AccountType" == "ldap" ]; then
		ln -sf ${PAM_LDAP_SRC} ${PAM_SMTP_LINK}
		ln -sf ${PAM_LDAP_BLOCK_SRC} ${PAM_DOVECOT_LINK}
	elif [ "$AccountType" == "win" ]; then
		ln -sf ${PAM_WIN_SRC} ${PAM_SMTP_LINK}
		ln -sf ${PAM_WIN_BLOCK_SRC} ${PAM_DOVECOT_LINK}
	else
		HaveAutoBlockPam
		if [ $? -eq "1" ]; then
			ln -sf ${PAM_UNIX_SRC} ${PAM_SMTP_LINK}
			ln -sf ${PAM_UNIX_BLOCK_SRC} ${PAM_DOVECOT_LINK}
		else
			ln -sf ${PAM_UNIX_SRC} ${PAM_SMTP_LINK}
			ln -sf ${PAM_UNIX_SRC} ${PAM_DOVECOT_LINK}
		fi
	fi
}

GenAliases() {
	$GenConfValue aliases
	$PostAlias $AliasConf
}

GenLdapAlias() {
	if [ "$AccountType" == "ldap" ]; then
		$GenConfValue ldap_alias
	fi
}

SMTP() {
	# create dovecot link for pam.d login
	CreatePamLink

	#gen aliases for Domain user
	GenAliases
	GenLdapAlias

	cat $PostfixTemplate > /tmp/tempinfo

	#smtp setting
	AliasMap="hash:/var/packages/MailServer/target/etc/aliases"
	if [ "$AccountType" == "ldap" ]; then
                AliasMap=${AliasMap}", ldap:/var/packages/MailServer/target/etc/ldap-aliases.cf"
        fi
	echo "alias_maps = $AliasMap" >> /tmp/tempinfo

	HostName=`/bin/get_key_value $MailServerConf smtp_hostname`
	if [ -z "$HostName" ]; then
		HostName="localhost"
	fi
	echo "myhostname = $HostName" >> /tmp/tempinfo

	SmtpAuth=`/bin/get_key_value $MailServerConf smtp_auth_enabled`
	if [ "$SmtpAuth" != "yes" ]; then
		SmtpAuth="no"
	fi
	echo "smtpd_sasl_auth_enable = $SmtpAuth" >> /tmp/tempinfo

	SmtpIgnoreLAN=`/bin/get_key_value $MailServerConf smtp_ignore_lan_auth`
	if [ "$SmtpAuth" = "yes" ] && [ "${SmtpIgnoreLAN}" = "no" ]; then
		if [ "$IPV4" = "yes" ]; then
			echo "mynetworks = 127.0.0.0/8" >> /tmp/tempinfo
		else
			echo "mynetworks = 127.0.0.0/8, [::1]/128" >> /tmp/tempinfo
		fi
	fi

	Domain=`/bin/get_key_value $MailServerConf canonical_domain`
	if [ -z  "$Domain" ]; then
		echo "mydestination = \$myhostname, localhost.\$mydomain, localhost" >> /tmp/tempinfo
	else
		echo "mydestination = \$myhostname, localhost.\$mydomain, localhost, $Domain" >> /tmp/tempinfo
	fi

	MessageSizeLimit=`/bin/get_key_value $MailServerConf message_limit`
	if [ -z "$MessageSizeLimit" ]; then
		MessageSizeLimit=10240000
	else
		MessageSizeLimit=`/usr/bin/expr $MessageSizeLimit \* 1048576`
	fi
	echo "message_size_limit = $MessageSizeLimit" >> /tmp/tempinfo

	RestrictSender=`/bin/get_key_value ${MailServerConf} restrict_sender`
	if [ ${RestrictSender} = "yes" ]; then
		echo "smtpd_sender_login_maps = hash:${LoginMap}" >> /tmp/tempinfo
		echo "smtpd_sender_restrictions = reject_authenticated_sender_login_mismatch, reject_unknown_sender_domain" >> /tmp/tempinfo
	else
		echo "smtpd_sender_restrictions = reject_unknown_sender_domain" >> /tmp/tempinfo
	fi

	local spam_enable=`/bin/get_key_value $MailServerConf spam_enable`
	local anti_virus_enable=`/bin/get_key_value ${MailServerConf} anti_virus_enable`
	if [ x"${spam_enable}" = x"yes" -o x"${anti_virus_enable}" = x"yes" ]; then
		echo "header_checks = regexp:/var/packages/MailServer/target/etc/header_checks" >> /tmp/tempinfo
		echo "/^Received:/ HOLD" > /var/packages/MailServer/target/etc/header_checks
	fi

	local always_bcc=`/bin/get_key_value ${MailServerConf} always_bcc`
	if [ ! -z ${always_bcc} ]; then
		echo "always_bcc = ${always_bcc}" >> /tmp/tempinfo
	fi

	SmtpEnable=`/bin/get_key_value $MailServerConf smtp_enabled`

	# SMTP-SSL
	SmtpsEnable=`/bin/get_key_value $MailServerConf smtp_ssl_enabled`
	if [ "$SmtpEnable" = "yes" ] && [ "$SmtpsEnable" = "yes" ]; then
		echo "smtpd_use_tls = yes" >> /tmp/tempinfo
		echo "tls_random_source = dev:/dev/urandom" >> /tmp/tempinfo
	fi

	#relay setting
	RelayEnable=`/bin/get_key_value $MailServerConf smtp_relay_enabled`
	if [ "$SmtpEnable" = "yes" ] && [ "$RelayEnable" = "yes" ]; then
		RelayServer=`/bin/get_key_value $MailServerConf smtp_relay_server`
		RelayPort=`/bin/get_key_value $MailServerConf smtp_relay_server_port`

		if [ ! -z "$RelayServer" ] && [ ! -z "$RelayPort" ]; then
			echo "relayhost = ${RelayServer}:${RelayPort}" >> /tmp/tempinfo
			RelayAuth=`/bin/get_key_value $MailServerConf smtp_relay_auth_enabled`
			RelayTLS=`/bin/get_key_value $MailServerConf smtp_relay_secure_conn`
			if [ "$RelayTLS" == "yes" ]; then
				echo "smtp_use_tls = $RelayTLS" >> /tmp/tempinfo
				echo "smtp_sasl_tls_security_options = noanonymous" >> /tmp/tempinfo
			fi

			if [ "$RelayAuth" == "yes" ]; then
				echo "smtp_sasl_auth_enable = $RelayAuth" >> /tmp/tempinfo
				echo "smtp_sasl_password_maps = hash:/var/packages/MailServer/target/etc/sasl_passwd" >> /tmp/tempinfo
				echo "smtp_sasl_security_options = noanonymous" >> /tmp/tempinfo
				$SetRelayAuth
			fi
		fi
	fi

	#set spam-filter: DNSBL
        SmtpdRecipientRestriction="check_client_access hash:/var/packages/MailServer/target/etc/access/client_access,
				check_sender_access hash:/var/packages/MailServer/target/etc/access/sender_access,
				check_recipient_access hash:/var/packages/MailServer/target/etc/access/recipient_access,
				permit_mynetworks,
				permit_sasl_authenticated,
				reject_unauth_destination"
	DNSBLEnable=`/bin/get_key_value $MailServerConf spam_dnsbl_enable`
	if [ "$DNSBLEnable" == "yes" ]; then
		DNSBLServer=`$GenConfValue dnsbl`
		if [ ! -z "${DNSBLServer}" ]; then
			SmtpdRecipientRestriction="${SmtpdRecipientRestriction},\n ${DNSBLServer}"
		fi
	fi
	echo -e "smtpd_recipient_restrictions = ${SmtpdRecipientRestriction}" >> /tmp/tempinfo

	/bin/mv /tmp/tempinfo $PostfixConf
	
	if [ x"${RelayEnable}" = x"yes" ]; then
		${PackagePath}/target/sbin/postmap ${PackagePath}/target/etc/sasl_passwd
		rm -rf ${PackagePath}/target/etc/sasl_passwd
	fi
}

Alias() {
	GenAliases
}

Protocol() {

	local pid="$$"
	local dovecot_master_conf="$PackagePath/target/etc/dovecot/conf.d/master.conf"
	local dovecot_temp_master_conf=${dovecot_master_conf}.${pid}
	local imap_localhost_conf="$PackagePath/target/etc/dovecot/conf.d/imap.conf"
	local protocols="imap"

	local imap_enabled=`/bin/get_key_value $MailServerConf imap_enabled`
	local imaps_enabled=`/bin/get_key_value $MailServerConf imaps_enabled`
	local pop3_enabled=`/bin/get_key_value $MailServerConf pop3_enabled`
	local pop3s_enabled=`/bin/get_key_value $MailServerConf pop3s_enabled`

	#set protocols
	if [ x"${pop3_enabled}" = x"yes" -o x"${pop3s_enabled}" = x"yes" ]; then
		protocols="${protocols} pop3"
	fi

	if [ x"${imaps_enabled}" = x"yes" ]; then
		imaps_port="993"
	fi

	if [ x"${pop3_enabled}" = x"yes" ]; then
		pop3_port="110"
	fi

	if [ x"${pop3s_enabled}" = x"yes" ]; then
		pop3s_port="995"
	fi

	# set protocols
	echo -e "protocols = ${protocols:="imap"}" > ${dovecot_temp_master_conf}

	# set imap port setting
	echo -e "service imap-login {
	service_count = 0
	process_limit = 256
	inet_listener imap {
		port = 143
	}
	inet_listener imaps {
		port = ${imaps_port:="0"}
		ssl = yes
	}\n}\n" >> ${dovecot_temp_master_conf}

	# set pop3 port setting
	echo -e "service pop3-login {
	service_count = 0
	process_limit = 256
	inet_listener pop3 {
		port = ${pop3_port:="0"}
	}
	inet_listener pop3s {
		port = ${pop3s_port:="0"}
		ssl = yes
	}\n}\n" >> ${dovecot_temp_master_conf}

	# if imap not enable, it means imap only listen localhost:143
	echo -e "protocol imap {" > ${imap_localhost_conf}.$$
	if [ x${imap_enabled} != x"yes" ]; then
		echo -e	"listen = localhost:143" >> ${imap_localhost_conf}.$$
	fi
	echo -e	"}" >> ${imap_localhost_conf}.$$

	# rename master conf
	mv ${imap_localhost_conf}.$$ ${imap_localhost_conf}
	mv ${dovecot_temp_master_conf} ${dovecot_master_conf}
}


MasterCf() {

	local temp_config=${MasterConf}.$$

	# SMTP-SSL
	local smtp_enable=`/bin/get_key_value $MailServerConf smtp_enabled`
	local smtps_enable=`/bin/get_key_value $MailServerConf smtp_ssl_enabled`

	local smtp_port=`/bin/get_key_value $MailServerConf smtp_port`
	: ${smtp_port:="25"}
	local smtps_port=`/bin/get_key_value $MailServerConf smtps_port`
	: ${smtps_port:="465"}

	cat ${MasterTemplate} > ${temp_config}

	echo "${smtp_port} inet n - n - - smtpd" >> ${temp_config}

	if [ x"${smtps_enable}" = x"yes" ]; then
		echo "${smtps_port} inet n - n - - smtpd -o smtpd_tls_wrappermode=yes -o smtpd_sasl_auth_enable=yes" >> ${temp_config}
	fi

	/bin/mv ${temp_config} ${MasterConf}

}

# set Spamassassin config
MailScanner()
{
	cp ${MailScannerTemplate} ${MailScannerConf}.$$
	cp ${SpamassassinTemplate} ${SpamassassinConf}.$$

	#local temp_config=${SpamassassinConf}.$$
	local spam_enable=`/bin/get_key_value $MailServerConf spam_enable`
	: ${spam_enable:="no"}

	local anti_virus_enable=`/bin/get_key_value ${MailServerConf} anti_virus_enable`
	: ${anti_virus_enable:="no"}

	echo "Virus Scanning = ${anti_virus_enable}" >> ${MailScannerConf}.$$
	echo "Spam Checks = ${spam_enable}" >> ${MailScannerConf}.$$

	local required_score=`/bin/get_key_value $MailServerConf spam_required_score`
	: ${required_score:="5.0"}

	local enable_rewrite=`/bin/get_key_value $MailServerConf spam_enable_rewrite`
	: ${enable_rewrite:="yes"}

	local rewrite_subject=`/bin/get_key_value $MailServerConf spam_rewrite_subject`
	: ${rewrite_subject:='{Spam?}'}

	local spam_action=`/bin/get_key_value $MailServerConf spam_report_machanism`
	: ${spam_action:="1"}

	echo "Required SpamAssassin Score = ${required_score}" >> ${MailScannerConf}.$$
	echo "High SpamAssassin Score = ${required_score}" >> ${MailScannerConf}.$$

	if [ x"${enable_rewrite}" = x"yes" ]; then
		echo "Spam Modify Subject = start" >> ${MailScannerConf}.$$
		echo "Spam Subject Text = ${rewrite_subject}" >> ${MailScannerConf}.$$
		echo "High Scoring Spam Modify Subject = start" >> ${MailScannerConf}.$$
		echo "High Scoring Spam Subject Text = ${rewrite_subject}" >> ${MailScannerConf}.$$
	else	
		echo "Spam Modify Subject = no" >> ${MailScannerConf}.$$
		echo "High Scoring Spam Modify Subject = no" >> ${MailScannerConf}.$$
	fi

	local action=""
	if [ "${spam_action}" = "1" ]; then
		action="attachment"
	elif [ "${spam_action}" = "2" ]; then
		action="striphtml"
	fi

	echo "Spam Actions = ${action} deliver header \"X-Spam-Flag: Yes\"" >> ${MailScannerConf}.$$
	echo "High Scoring Spam Actions = ${action} deliver header \"X-Spam-Flag: Yes\"" >> ${MailScannerConf}.$$

	local use_auto_learn=`/bin/get_key_value ${MailServerConf} spam_auto_learn`
	: ${use_auto_learn:="no"} 

	local auto_learn_threshold_spam=`/bin/get_key_value ${MailServerConf} spam_learn_threshold_spam`
	: ${auto_learn_threshold_spam:="12"}

	local auto_learn_threshold_non_spam=`/bin/get_key_value ${MailServerConf} spam_learn_threshold_non_spam`
	: ${auto_learn_threshold_non_spam:="0.1"}

	local use_auto_whitelist=`/bin/get_key_value ${MailServerConf} spam_auto_whitelist`
	: ${use_auto_whitelist:="no"} 

	if [ x"${use_auto_learn}" = x"yes" ]; then
		echo "use_bayes 1" >> ${SpamassassinConf}.$$
		echo "bayes_auto_learn 1" >> ${SpamassassinConf}.$$
		echo "bayes_auto_learn_threshold_spam ${auto_learn_threshold_spam}" >> ${SpamassassinConf}.$$
		echo "bayes_auto_learn_threshold_nonspam ${auto_learn_threshold_non_spam}" >> ${SpamassassinConf}.$$
	else
		echo "use_bayes 0" >> ${SpamassassinConf}.$$
		echo "bayes_auto_learn 0" >> ${SpamassassinConf}.$$
	fi

	echo "SpamAssassin Auto Whitelist = ${use_auto_whitelist}" >> ${MailScannerConf}.$$
	if [ x"${use_auto_whitelist}" = x"yes" ]; then
		echo "use_auto_whitelist 1" >> ${SpamassassinConf}.$$
	else
		echo "use_auto_whitelist 0" >> ${SpamassassinConf}.$$
	fi
	
	/bin/mv ${SpamassassinConf}.$$ ${SpamassassinConf}
	/bin/mv ${MailScannerConf}.$$ ${MailScannerConf}
}

GetAllUsers() {
    synouser --enum local | sed '1d' | while read user
    do
        ALL_USERS=${ALL_USERS}","${user}
        echo ${ALL_USERS} > /tmp/user.all
    done
    ALL_USERS=`cat /tmp/user.all | sed 's/.\(.*\)/\1/'`
    rm -rf /tmp/user.all
}

case "$1" in
	smtp)
		SMTP
		MasterCf
		;;
	protocol)
		Protocol
		;;
	alias)
		Alias
		;;
	spam)
		MailScanner
		;;
	anti-virus)
		MailScanner
		;;
	mailscanner)
		MailScanner
		;;
	*)
		echo "Usage: $0 {smtp|protocol|alias|spam|anti-virus|mailscanner}" >&2
		exit 1
		;;
esac
