#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

LOG_DAEMON_PID="/var/run/mailplus_server/syno_mailloggerd.pid"

bin_status()
{
	#check syno_maillogd
	checkPidFileStatus "syno_mailloggerd" "${LOG_DAEMON_PID}"
}

conf_status()
{
	checkConfKey "smtp_enabled"
	return $?
}

status()
{
	conf_status
	local mailloggerd_enable=$?
	bin_status
	local mailloggerd_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${mailloggerd_status} ] && [ "${RUNKEY_DISABLE}" -ne "${mailloggerd_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${mailloggerd_status} ] && [ "${RUNKEY_ENABLE}" -ne "${mailloggerd_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${mailloggerd_status}
}

start()
{
	echo "Starting Maillog Daemon..."
	initctl start pkg-MailPlus-Server_mailloggerd

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status syno_mailloggerd: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}
}

checkStopped()
{
	waitTillPidRemoved "${LOG_DAEMON_PID}"
	local status=$?
	if [ "${FAIL}" -eq "${status}" ]; then
		# Force stop
		local pid=$(cat ${LOG_DAEMON_PID})
		kill -9 "${pid}" &> /dev/null
	fi
}

stop()
{
	echo "Stop Log Daemon..."
	initctl stop pkg-MailPlus-Server_mailloggerd
	checkStopped
}

restart()
{
	stop
	sleep 1
	start
}

composePID()
{
	local pid=$(cat ${LOG_DAEMON_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/syno_mailloggerd.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_syno_mailloggerd"
		;;
	restart)
		restartOperation "mailserver_service_syno_mailloggerd"
		;;
	stop)
		stopOperation "mailserver_service_syno_mailloggerd"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
