#!/bin/sh
MAILPLUS_SERVER_DOVEADM_BINARY="/var/packages/MailPlus-Server/target/bin/doveadm"
MAILPLUS_SERVER_BACKEND_BINARY="/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend"
TMP_USER_LIST="/var/services/tmp/mailplus_server_user_list"
account_type=`${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal account_type`
if [ "${account_type}" = "win" ]; then
	account_type="domain"
fi
/usr/syno/sbin/synouser --enum ${account_type} | sed '1d' > "${TMP_USER_LIST}"
cat ${TMP_USER_LIST} | while read -r mailbox_owner;
do
    stripe_mailbox_owner=""
    if [ "${account_type}" = "ldap" ]; then
        stripe_mailbox_owner=`echo "${mailbox_owner}" | cut -d "@" -f 1`
    else
        #local and domain
        stripe_mailbox_owner="${mailbox_owner}"
    fi

    maildir_path=`${MAILPLUS_SERVER_BACKEND_BINARY} --getMailDir "${mailbox_owner}"`
    if [ ! -d "${maildir_path}" ]; then
        continue
    fi

#   echo "processing $mailbox_owner ..."

    ${MAILPLUS_SERVER_DOVEADM_BINARY} mailbox list -u "${mailbox_owner}" | grep "^synology_internal_shared_namespace\..*\..*" | while read -r mailbox;
    do
        stripe_mailbox_owner=`echo "${stripe_mailbox_owner}" | sed "s/\./\//g"`
#       echo "owner (striped): $mailbox_owner ($stripe_mailbox_owner), mailbox: $mailbox"

        ${MAILPLUS_SERVER_DOVEADM_BINARY} acl get -u ${mailbox_owner} "${mailbox}" | while read -r id rights
        do
            if [[ $rights != *"write-seen"* ]]; then
                #echo "no write-seen perm (owner, mailbox, id, rights): $mailbox_owner, $mailbox, $id, $rights"
                rights="$rights write-seen"
                ${MAILPLUS_SERVER_DOVEADM_BINARY} acl set -u "${mailbox_owner}" "${mailbox}" "${id}" ${rights}
            fi
        done
    done
done
rm "${TMP_USER_LIST}"
