#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

POSTFIX_SCRIPT="${MAIL_SERVER_PKG}/target/scripts/daemon/postfix.sh"
SASLAUTHD_SCRIPT="${MAIL_SERVER_PKG}/target/scripts/daemon/saslauthd.sh"
NOTIFIERD_SCRIPT="${MAIL_SERVER_PKG}/target/scripts/daemon/syno_mailserver_notifierd.sh"

start() {

	${SASLAUTHD_SCRIPT} start

	${NOTIFIERD_SCRIPT} start

	${POSTFIX_SCRIPT} start
}

stop() {

	${SASLAUTHD_SCRIPT} stop

	${POSTFIX_SCRIPT} stop

	${NOTIFIERD_SCRIPT} stop
}

restart() {
	stop
	sleep 1
	start
}

reload() {

	${SASLAUTHD_SCRIPT} reload

	${POSTFIX_SCRIPT} reload

	${NOTIFIERD_SCRIPT} reload
}

status()
{
	${POSTFIX_SCRIPT} status
}

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		restart
		;;
	reload)
		reload
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|reload|status}" >&2
		exit 1
		;;
esac
