#!/usr/bin/python

import sys
sys.path.append("/var/packages/MailPlus-Server/target/backend_hook/")

from _Utils import *

def parseOldActiveDBDumpFile(dump_file_path):
	activate_list = []
	deactivate_list = []
	obj = {};
	with open(dump_file_path, "r") as fp:
		for line in fp:
			s = line.strip().split("|")
			obj["name"] = s[0]
			obj["type"] = s[1]
			if s[2] == "true":
				activate_list.append(obj.copy());
			elif s[2] == "false":
				deactivate_list.append(obj.copy());
	return activate_list, deactivate_list

def main():
	if len(sys.argv) != 2:
		SYSLOG(LOG, "usage: ./syno_upgrade_active_db_tool old_dump_file_path")
		exit(1)

	activate_list, deactivate_list = parseOldActiveDBDumpFile(sys.argv[1])
	resp = execWebAPI("SYNO.MailPlusServer.License", "edit_activate_member", 1,
		activate_list=activate_list,
		deactivate_list=deactivate_list
	)
	if not resp["success"]:
		if 5588 == resp["error"]["code"]:
			SYSLOG(LOG_ERR, "activate user too much, but skip error")
		else:
			SYSLOG(LOG_ERR, "send webapi edit_activate_member fail")
			exit(1)
	exit(0)

if __name__ == '__main__':
	main()
