#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_PATH_X, SHARE_OP_RESULT_X
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
. /var/packages/MailPlus-Server/target/hook/MailPlusServerShareCommon.sh

#At begining, acquire package settings
PackageInfoGet;

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
		echo "2.0";
    ;;
    --name)
        #Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
    ;;
    --pkg-ver)
        #Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
    ;;
    --vendor)
        #Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
    ;;
    --pre)
    ;;
    --post)
        #Actions after share delete
        
		#Check if service share
		ARCHIVE_DEST_SHARE=""
		ARCHIVE_ENABLED="no"
		GetArchiveSetting
        
		SHARE_IDX=0;
        CNT=1;
        NITEMS=$((NITEMS + 1));

        #Check if service share
        while [ "${CNT}" != "${NITEMS}" ]
        do
            eval "CHK_SHARE=\$SHARE_PATH_$CNT"
            SvrShareCheck;
            if [ "1" = "${IS_DEST_SHARE}" ]; then
                SHARE_IDX=${CNT};
				break
            fi

            CNT=$((CNT + 1));
        done
        if [ "0" == "${SHARE_IDX}" ]; then
            exit;
        fi

        #Send notification when removal is success
        eval "RESULT=\$SHARE_OP_RESULT_$SHARE_IDX"
		
		#remove success
        if [ "0x0000" = "${RESULT}" -a "yes" == ${ARCHIVE_ENABLED} ]; then
			${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "archive_enable_schedule" "no"
			SendShareRemoveNotification ${ARCHIVE_DEST_SHARE}
        fi

        ################################################
        # PS: Service is resumed/disabled by service framework
        ################################################
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
