#!/bin/sh

###############################################################
#	This script should be hooked when SynoAV-McAfee is stopped
###############################################################

NOT_SHUTTING_DOWN="System is not shutting down"

LOG_ERR=3

err_log() {
	logger -u '/var/run/syslog' -t 'MailPlus-Server' -p ${LOG_ERR} "<$0>: " "$@"
}

boot_status="$(synobootseq --is-shutdown)"

if [ "${NOT_SHUTTING_DOWN}" == "${boot_status}" ] && ([ "STOP" == "${SYNOPKG_PKG_STATUS}" ] || [ "UNINSTALL" == "${SYNOPKG_PKG_STATUS}" ]); then
	err_log "AntiVirus-McAfee is going to stop, fallback to clamav"
	/var/packages/MailPlus-Server/target/scripts/daemon/synoav_mcafee.sh fallback_to_clamav
fi
