#!/usr/bin/python
#--*-- coding:utf8 --*--

import sys
import os
import string
import hashlib

sys.path.append("/var/packages/MailPlus-Server/target/backend_hook/")
from _Utils import *
from _Define import *

cAPI = BackendAPI()

ConfigExcludeList = [
    #"custom_file",
    "personal"
]

CompatibleRestoreFileList = [
    "/var/packages/MailPlus-Server/etc/mailserver.db",
    "/var/packages/MailPlus-Server/etc/active_list.db",
    "/var/packages/MailPlus-Server/etc/dkim.key/dkim.private",
    "/var/packages/MailPlus-Server/etc/dkim.key/dkim.public",
    "/var/packages/MailPlus-Server/etc/alias.db",
    "/var/packages/MailPlus-Server/etc/attachment_filter.db",
    "/var/packages/MailPlus-Server/target/etc/bcc/sender_bcc",
    "/var/packages/MailPlus-Server/target/etc/bcc/recipient_bcc",
]

CompatibleRestoreFolderList = [
    "/var/packages/MailPlus-Server/etc/rules/"
]

BackupSettingJsonFile = "backup_config.json"

def getFileSectionTree():
    import ConfigParser

    fileTreeList = []
    config = ConfigParser.ConfigParser()
    config.read(MONITOR_PATH_BUILD)

    fileTreeList = [_[0] for _ in config.items(SECTION_FILE) if _[0]]
    return fileTreeList

def excludeTree(tree, blExcludePersonal):
    if tree == "kv_file_upload":
        return True
    elif blExcludePersonal and tree in ConfigExcludeList:
        return True

    return False


def hashSrcFilePath(backupDir, srcFilePath):
    baseNamePrefix = hashlib.md5(srcFilePath).hexdigest()
    dstBaseName = baseNamePrefix
    idx = 0
    while os.path.isfile(os.path.join(backupDir, dstBaseName)):
        dstBaseName = '{0}.{1}'.format(baseNamePrefix, idx)
        idx = idx + 1
    return dstBaseName

def backup(backupDir, blBackupFile, blExcludePersonal):
    import shutil
    import json
    if not os.path.isdir(backupDir):
        SYSLOG(LOG_ERR, "Dir [%s] not exist" % (backupDir))
        exit(1)

    backupFile = os.path.join(backupDir, BackupSettingJsonFile)
    if os.path.isfile(backupFile):
        os.unlink(backupFile)
    if os.path.isdir(backupFile):
        shutil.rmtree(backupFile)
    outputJson = {}
    fileTreeList = getFileSectionTree()

    for tree in fileTreeList:
        if excludeTree(tree, blExcludePersonal):
            continue
        result = cAPI.getTree(tree)
        if not result:
            continue
        for key in result.keys():
            fileST = json.loads(result[key])
            try:
                srcFilePath = fileST["srcFilePath"].encode('utf8')
                if not os.path.isfile(srcFilePath):
                    continue
                if blBackupFile:
                    hashBaseName = hashSrcFilePath(backupDir, srcFilePath)
                    dstFilePath = os.path.join(backupDir, hashBaseName)
                    st = os.stat(srcFilePath)
                    shutil.copy2(srcFilePath, dstFilePath)
                    os.chown(dstFilePath, st.st_uid, st.st_gid)
                    fileST["hashBaseName"] = hashBaseName
                outputJson[key] = fileST
            except Exception as e:
                SYSLOG(LOG_ERR, "Failed to parse error [%s]" % (e))
                continue
    with open(backupFile, "w") as wp:
        wp.write(json.dumps(outputJson))

def getCompatibleFileBaseName(path):
    for val in CompatibleRestoreFolderList:
        if path.startswith(val):
            return os.path.basename(path)

    if path in CompatibleRestoreFileList:
        return os.path.basename(path)

    return ''

def restore(restoreDir, blBackupFile, blExcludePersonal):
    import shutil
    import json

    def _createFolders(fileST):
        if not fileST.has_key("pathInfo"):
            return
        pathInfo = fileST["pathInfo"]
        for d in pathInfo.keys():
            if not os.path.isdir(d.encode('utf8')) and pathInfo[d]["isDir"]:
                try:
                    os.makedirs(d)
                    os.chown(d, pathInfo[d]["uid"], pathInfo[d]["gid"])
                    os.chmod(d, pathInfo[d]["mode"])
                except Exception as e:
                    SYSLOG(LOG_ERR, "Failed to create dir [%s] error [%s]" % (d, e))

    if not os.path.isdir(restoreDir):
        SYSLOG(LOG_ERR, "Dir [%s] does not exist" % (restoreDir))
        exit(1)

    restorePath = os.path.join(restoreDir, BackupSettingJsonFile)
    if not os.path.isfile(restorePath):
        SYSLOG(LOG_ERR, "file [%s] does not exist" % (restorePath))
        exit(1)

    with open(restorePath) as fp:
        jData = fp.read()
        backupList = json.loads(jData)
        for key in backupList.keys():
            if key.startswith("file_upload_hook-"):
                continue

            fileST = backupList[key]
            try:
                filePath = fileST["srcFilePath"].encode('utf8')

                if blBackupFile:
                    fileBaseName = ''
                    #For Compatible only restore whitelist
                    if "hashBaseName" not in fileST.keys():
                        fileBaseName = getCompatibleFileBaseName(fileST["srcFilePath"])
                        if '' == fileBaseName:
                            continue
                    else:
                        fileBaseName = fileST["hashBaseName"]

                    fileBaseName = fileBaseName.encode('utf8')

                    backupFilePath = os.path.join(restoreDir, fileBaseName).encode('utf8')
                    if os.path.isfile(backupFilePath):
                        _createFolders(fileST)
                        st = os.stat(backupFilePath)
                        shutil.copy2(backupFilePath, filePath)
                        os.chown(filePath, st.st_uid, st.st_gid)

                if os.path.isfile(filePath):
                    if "scriptPath" in fileST.keys() and fileST["scriptPath"]:
                        if "scriptArgs" in fileST.keys() and fileST["scriptArgs"]:
                            cAPI.syncFile(filePath.decode('utf8'), fileST["scriptPath"], " ".join(fileST["scriptArgs"]))
                        else:
                            cAPI.syncFile(filePath.decode('utf8'), fileST["scriptPath"])
                    else:
                        cAPI.setFile(key, filePath.decode('utf8'))
            except Exception as e:
                SYSLOG(LOG_ERR, "Failed to parse error [%s]" % (e))
                continue

def main():
    import shutil
    import optparse

    parser = optparse.OptionParser(usage=main.__doc__)
    parser.add_option('-b', '--backup-dir', dest='backupDir',
            type=str, help=('backup dir'))
    parser.add_option('-r', '--restore-dir', dest='restoreDir',
            type=str, help=('restore dir'))
    parser.add_option('-e', '--exclude-person-config', dest='blExcludePersonal',
            action='store_true', default=False, help=('restore config exclude personal setting[default: False]'))
    options, args = parser.parse_args()

    SYSLOG(LOG_ERR, "Start to config sync....")

    if options.backupDir:
        backup(options.backupDir, True, options.blExcludePersonal)
    elif options.restoreDir:
        restore(options.restoreDir, True, options.blExcludePersonal)
    else:
        ## Become daemon mode
        pid = os.fork()
        if pid == 0:
            exit(0)
        pid = os.fork()
        if pid > 0:
            exit(0)

        backupTmpDir = "/tmp/.mapluse_config_backup_dir"
        if os.path.exists(backupTmpDir):
            shutil.rmtree(backupTmpDir)
        os.mkdir(backupTmpDir)

        backup(backupTmpDir, False, False)
        restore(backupTmpDir, False, False)

        shutil.rmtree(backupTmpDir)

    SYSLOG(LOG_ERR, "Config sync done....")

if __name__ == '__main__':
    main()
    exit(0)
