#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Actions
if containString "node_ip_list-" "${_MAIL_mailserver_trigger_events}"; then

	## update certificate certificate with new IPs
	nodeID="$(getHostID)"
	if containString "node_ip_list-${nodeID}" "${_MAIL_mailserver_trigger_events}" && ! GenerateInternalCert "onlyCert"; then
		err_log "Failed to regen certificate after ip list changes"
	fi

	oriMasterIP="$(${BACKEND_BINARY} backend-command --command get_redis_master_ip)"
	newMasterIP=$(${BACKEND_BINARY} "backend-command" --command "get" --key "/tmp/new_master_ip")
	if [ "127.0.0.1" != "${oriMasterIP}" -a -n "${newMasterIP}" -a "${oriMasterIP}" != "${newMasterIP}" ]; then
		info_log "IP change: Updater masterIP to ${newMasterIP}"
		${BACKEND_BINARY} "backend-command" --command new_master_ip --newMasterIP "${newMasterIP}"
	fi

	if ! ${CALLBACK_BINARY} "refresh_firewall" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to update firewall"
		exit 1
	fi
fi

exit 0
