#!/bin/sh
## FIXME
exit 0
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

STORAGE_PATH="/${VOLUME}/@MailDir"
TIMES=30
NODE_ID=$(getHostID)

## Check identity
## Storage node leave
storage_node=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "storager")
if containString "${NODE_ID}" "${storage_node}"; then
	## FIXME: if change storage have to umount
	#umount -fl ${STORAGE_PATH} 2> /dev/null
	exit 0
fi

## Not mail backend node leave
mail_node=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")
if ! containString "${NODE_ID}" "${mail_node}"; then
	exit 0
fi

curMountIP="$(cat /proc/mounts | grep "${STORAGE_PATH}" | awk -F':' '{print $1}')"
static_mapping_IP="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "storage_static_mapping-${NODE_ID}")"

getNewLinkIP()
{
	local storage_servers=${_MAIL_mailserver_service_storage_backend}
	local aliveServer=""

	## FIXME: should algorithm
	## Check if static mapping server in alive server
	for serv in ${storage_servers}; do
		if [ "${serv}" == "${static_mapping_IP}" ]; then
			aliveServer=${static_mapping_IP}
			break
		fi
		aliveServer=${serv}
	done

	echo "${aliveServer}"
}
reMount()
{
	local i=
	local mounted=1

	err_log "Try to mount ${newLinkIP}"
	/usr/bin/umount -fl "${STORAGE_PATH}"

	### FIXME: change link should get lock or something
	if [ -L "${MAIL_STORAGE_DIR_PATH}" ]; then
		/usr/bin/rm -fr "${MAIL_STORAGE_DIR_PATH}"
	elif [ -d "${MAIL_STORAGE_DIR_PATH}" ]; then
		## FIXME: it should never be non symbolic link
		/usr/bin/mv "${MAIL_STORAGE_DIR_PATH}" "${MAIL_STORAGE_DIR_PATH_BAK}"
	fi

	local exportKey="general_storage_volume-${NODE_ID}"
	local exportVolume="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "${exportKey}")"
	local exportPath="/${exportVolume}/@MailDir"

	## Retry mount for times due to storage server may enable later
	for i in $(seq 1 1 ${TIMES}); do
		/usr/bin/mount -o vers=4,tcp,soft,timeo=100 "${newLinkIP}:${exportPath}" "${STORAGE_PATH}"
		if [ 0 -eq $? ]; then
			mounted=0
			/usr/bin/ln -s "${STORAGE_PATH}" "${MAIL_STORAGE_DIR_PATH}"
			break
		fi
		sleep 1
	done
	if [ ${mounted} -ne 0 ]; then
		err_log "Failed to mount ${newLinkIP}:${exportPath} to ${STORAGE_PATH}"
		return 1
	fi

	##FIXME: need to change value of "storage_runtime_mapping-${NODE_ID}" to "${newLinkIP}"
	return 0
}

## Remount
if isKeyChanged "general_storage_volume-${NODE_ID}" || isKeyChanged "mailserver_service_dovecot" || isKeyChanged "mailserver_service_storage_backend" \
	|| isKeyChanged "storage_static_mapping-${NODE_ID}"; then

	newLinkIP=$(getNewLinkIP)
	if [ "${newLinkIP}" != "${curMountIP}" ]; then
		reMount
	fi
fi
