#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"
if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

## Convert syno config
if ! ${SET_CONF_BINARY} "license"; then
	## SET_CONF_BINARY will be terminated when other ${SET_CONF_BINARY} license run...
	err_log "Failed to set conf license"
	#	exit 1
fi

## Convert syno config
if ! ${SET_CONF_BINARY} "local_recipients"; then
	## SET_CONF_BINARY will be terminated when other ${SET_CONF_BINARY} local_recipients run...
	err_log "Failed to set conf local_recipients"
#	exit 1
fi

## Actions
if isKeyChanged "active_user_list_db"; then
	if ! ${CALLBACK_BINARY} "active_user_list" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to callback active_user_list"
		exit 1
	fi
fi

## Actions
#/var/packages/MailPlus-Server/target/scripts/daemon/postfix.sh reload
#/var/packages/MailPlus-Server/target/scripts/daemon/dovecot.sh restart

exit 0
