#!/bin/bash
nice_value=16
function search()
{
	nice -n ${nice_value} /var/packages/MailPlus-Server/target/bin/doveadm search "$@" 2>/dev/null |
    while read -r user guid uid
    do
        nice -n ${nice_value} /var/packages/MailPlus-Server/target/bin/doveadm fetch -u "${user}" "user mailbox-guid uid hdr.from.address hdr.to.address hdr.cc.address hdr.bcc.address hdr.subject.utf8 size.physical date.received.epoch" mailbox-guid "${guid}" uid "${uid}"
    done
}
set -m
(search "$@")&
CHILD=$!
set +m
trap 'kill -kill -${CHILD}' term
wait
