#!/bin/bash

UPGRADE_FILE="/tmp/mailplus_server.upgrade"

update_process()
{
	local UPDATER=$1
	if [ -e "${UPDATER}" ] && [ -e "${UPGRADE_FILE}" ] ; then
		local OLD_PACKAGE_VER=$(get_key_value "${UPGRADE_FILE}" "old_version")
		local VERSION_DOT_NUM=$(echo "${OLD_PACKAGE_VER}" | awk 'BEGIN {FS="."} {print NF}')
		local MAJOR_VERSION=
		local MINOR_VERSION=
		local MAINTENANCE_NUM=
		local BUILD_NUMBER=
		if [ "${VERSION_DOT_NUM}" -eq 2 ]; then
			MAJOR_VERSION=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\1/')
			MINOR_VERSION=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\2/')
			BUILD_NUMBER=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\3/')
			BUILD_NUMBER=$(echo ${BUILD_NUMBER} | sed 's/^0*//')
			${UPDATER} -M ${MAJOR_VERSION} -m ${MINOR_VERSION} -v ${BUILD_NUMBER}
		else
			MAJOR_VERSION=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\1/')
			MINOR_VERSION=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\2/')
			MAINTENANCE_NUM=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\3/')
			BUILD_NUMBER=$(echo ${OLD_PACKAGE_VER} | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\4/')
			BUILD_NUMBER=$(echo ${BUILD_NUMBER} | sed 's/^0*//')
			${UPDATER} -M ${MAJOR_VERSION} -m ${MINOR_VERSION} -t ${MAINTENANCE_NUM} -v ${BUILD_NUMBER}
		fi
	fi
}

clear_upgeade_file()
{
	# general routine
	rm -f "${UPGRADE_FILE}"
}

