#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
SA_UPDATE="${MAIL_SERVER_PKG}/target/bin/sa-update"
RSPAMD_SCRIPT="${MAIL_SERVER_PKG}/target/scripts/daemon/rspamd.sh"
SECURITY_CHECK="${MAIL_SERVER_PKG}/target/scripts/SecurityCheck.sh"
ANTI_SPAM_UPDATE_STATUS="/tmp/mailplus_server/antispam_update_status.json"
SZF_UPDATE_LOCK="/tmp/mailplus_server/update.lock"
MAILPLUS_SERVER_VOLUME=`readlink "${MAIL_SERVER_PKG}/target" | /usr/bin/cut -d'/' -f2`
SA_UPDATE_LOG="/${MAILPLUS_SERVER_VOLUME}/@maillog/sa-update.log"
export PATH

run_sa_update()
{
	local status_tmp="${ANTI_SPAM_UPDATE_STATUS}.tmp.$$"
	local log_tmp="${SA_UPDATE_LOG}.tmp.$$"

	# set updating flag
	su MailPlus-Server -s /bin/sh -c "touch '${status_tmp}'"
	echo '{"status": "updating"}' > "${status_tmp}"
	mv "${status_tmp}" "${ANTI_SPAM_UPDATE_STATUS}"

	# run sa-update
	su MailPlus-Server -s /bin/sh -c "${SA_UPDATE} -D -v > ${log_tmp} 2>&1"
	local code=$?

	# sa-update creates the empty dir, so delete it
	rmdir "${MAIL_SERVER_PKG}/target/.spamassassin"

	# clear flag or set error flag
	if [ "0" -eq "${code}" ] || [ "1" -eq "${code}" ]; then
		rm "${ANTI_SPAM_UPDATE_STATUS}"
		rm "${log_tmp}"
	else
		su MailPlus-Server -s /bin/sh -c "touch '${status_tmp}'"
		echo "{\"status\": \"${code}\"}" > "${status_tmp}"
		mv "${status_tmp}" "${ANTI_SPAM_UPDATE_STATUS}"
		mv "${log_tmp}" "${SA_UPDATE_LOG}"
	fi
}

update_all()
{
	if isLoadBalancer; then
		nowTime=$(date "+%s")
		${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "spam_rule_last_update_time" "${nowTime}"
	fi
}

update_local()
{
	(
	if flock -x 8; then
		run_sa_update

		flock -u 8
		rm ${SZF_UPDATE_LOCK}
	fi
	)8> ${SZF_UPDATE_LOCK}

	${RSPAMD_SCRIPT} status
	if [ 0 -eq $? ]; then
		${RSPAMD_SCRIPT} reload
	else
		echo "Rspamd is not running."
	fi

	# update anti-spam status for dashboard
	${SECURITY_CHECK} "anti_spam"
}


case "$1" in
	all)
		update_all
		;;
	local)
		update_local
		;;
	*)
		echo "Usage: $0 {all|local}" >&2
		exit 1
		;;
esac
