#!/bin/sh
MAILPLUS_SERVER_DOVEADM_BINARY="/var/packages/MailPlus-Server/target/bin/doveadm"
MAILPLUS_SERVER_BACKEND_BINARY="/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend"
TMP_USER_LIST="/var/services/tmp/mailplus_server_user_list"
account_type=`${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal account_type`
if [ "${account_type}" = "win" ]; then
	account_type="domain"
fi
/usr/syno/sbin/synouser --enum ${account_type} > "${TMP_USER_LIST}"
cat ${TMP_USER_LIST} | while read -r mailbox_owner;
do
    stripe_mailbox_owner=""
    if [ "${account_type}" = "ldap" ]; then
        stripe_mailbox_owner=`echo "${mailbox_owner}" | cut -d "@" -f 1`
    else
        #local and domain
        stripe_mailbox_owner="${mailbox_owner}"
    fi
    ${MAILPLUS_SERVER_DOVEADM_BINARY} mailbox list -u "${mailbox_owner}" | while read -r mailbox;
    do
        stripe_mailbox_owner=`echo "${stripe_mailbox_owner}" | sed "s/\./\//g"`
        ${MAILPLUS_SERVER_DOVEADM_BINARY} acl get -F "${TMP_USER_LIST}" "synology_internal_shared_namespace.${stripe_mailbox_owner}.${mailbox}" | while read -r username id rights;
        do
            if [ "${id}" != "owner" ] && [ "${id}" != "anyone" ] && [ "${id}" != "authenticated" ]; then
                rights="$rights write-seen"
                ${MAILPLUS_SERVER_DOVEADM_BINARY} acl set -u "${mailbox_owner}" "${mailbox}" "${id}" ${rights}
            fi
        done
    done
done
rm "${TMP_USER_LIST}"
