#!/bin/sh

###############################################################
#	This script should be hooked when invoking user delete
#	Usable environment variable:
#		NITEMS, USER_NAME_X, USER_OP_RESULT_X, RESULT
###############################################################

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
HOOK="${MAIL_SERVER_PKG}/target/hook/AliasUserDelete.sh"
ACTIVE_DB_HOOK="${MAIL_SERVER_PKG}/target/hook/LicenseUserDelete.sh"
POLICY_HOOK="${MAIL_SERVER_PKG}/target/hook/UserGroupPolicyUserDelete.sh"
DELEGATION_HOOK="${MAIL_SERVER_PKG}/target/hook/DelegationUserDelete.sh"
DISCLAIMER_HOOK="${MAIL_SERVER_PKG}/target/hook/DisclaimerUserDelete.sh"
DOMAIN_USAGE_CATCHALL_HOOK="${MAIL_SERVER_PKG}/target/hook/DomainCatachAllUserDelete.sh"
CLEANUP_HOOK="${MAIL_SERVER_PKG}/target/hook/CleanupUserDelete.sh"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"
MULTIPLE_DOMAINS_BIN="${MAIL_SERVER_PKG}/target/bin/syno_multiple_domains"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --pre &
		${ACTIVE_DB_HOOK} --pre &
		${POLICY_HOOK} --pre &
		${DELEGATION_HOOK} --pre &
		${DISCLAIMER_HOOK} --pre &
		${DOMAIN_USAGE_CATCHALL_HOOK} --pre &
		${CLEANUP_HOOK} --pre &
		;;
	--post)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --post &
		${ACTIVE_DB_HOOK} --post &
		${POLICY_HOOK} --post &
		${DELEGATION_HOOK} --post &
		${DISCLAIMER_HOOK} --post &
		${DOMAIN_USAGE_CATCHALL_HOOK} --post &
		${CLEANUP_HOOK} --post &
		${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
		${MULTIPLE_DOMAINS_BIN} "refresh" &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
