#!/bin/sh

YES=0
NO=1

isDSM7OrAbove()
{
	local dsm_mayor_version="$(get_key_value /etc.defaults/VERSION majorversion)"
	if [[ "${dsm_mayor_version}" -gt 6 ]]; then
		return ${YES}
	else
		return ${NO}
	fi
}

isDsm6PkgStarted()
{
	local serverStatus="$(synopkg status MailPlus-Server | sed -n 1p)"
	if [[ "${serverStatus}" == *"started" ]]; then
		return ${YES}
	fi
	return ${NO}
}

isDsm6PkgEnable()
{
	local package="${1:-MailPlus-Server}"
	local enabled_flag="/var/packages/${package}/enabled"
	if [ -f "${enabled_flag}" ]; then
		return ${YES}
	fi
	return ${NO}
}

isDsm7PkgEnable()
{
	local package="${1:-MailPlus-Server}"
	local package_ctl="pkgctl-${package}"
	local status="$(systemctl is-active ${package_ctl})"
	if [ "${status}" == "activating" ] || [ "${status}" == "active" ]; then
		return ${YES}
	fi
	return ${NO}
}

isPackageEnable()
{
	local enabled_package_check="$1"
	if isDSM7OrAbove; then
		isDsm7PkgEnable "${enabled_package_check}"
	else
		isDsm6PkgEnable "${enabled_package_check}"
	fi
}

isPackageStarted()
{
	if isDSM7OrAbove; then
		isDsm7PkgEnable
	else
		isDsm6PkgStarted
	fi
}
