#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareSet()
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, SHARE_NAME, ORIGIN_SHARE_PATH, SHARE_PATH,
#       ORIGIN_SHARE_STATUS, SHARE_STATUS
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
. /var/packages/MailPlus-Server/target/hook/MailPlusServerShareCommon.sh

#At begining, acquire package settings
PackageInfoGet;
PATH_SUFFIX=""

LocationChangeCheck(){
	# Only hooked when share name or share path changed
	if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ] || [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
		NEED_HOOK=1;
	else
		NEED_HOOK=0;
	fi
}

LogAction(){
	#Check if service share
	ARCHIVE_DEST_SHARE=""
	ARCHIVE_ENABLED="no"
	GetArchiveSetting

	CHK_SHARE=${ORIGIN_SHARE_PATH};
	SvrShareCheck;
	if [ "1" != "${IS_DEST_SHARE}" ]; then
		return 0
	fi

	#Check hook condition
	LocationChangeCheck;
	if [ "1" != "${NEED_HOOK}" ]; then
		return 0
	fi

	#Check action success or not
	if [ "" = "$PATH_SUFFIX" ]; then
		${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "archive_destination" "${SHARE_PATH}"
	else
		${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "archive_destination" "${SHARE_PATH}${PATH_SUFFIX}"
	fi
}

MAILDIR_SHARE="MailPlus"
MailDirSharePreCheck(){
	## Create the share no need to do things
	if [ -z "${ORIGIN_SHARE_PATH}" ]; then
		return 1
	fi
	if [ "${SHARE_NAME}" != "${MAILDIR_SHARE}" -o "${SHARE_PATH}" == "${ORIGIN_SHARE_PATH}" ]; then
		return 1
	fi
	return 0
}
ParseVolume(){
	local fullPath="$1"
	## TODO: support usb,encription share
	echo "${fullPath}" | awk -F"/" '{print $2}'
}
SetNewVolume(){
	local newVolume="$1"
	local hostID="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID)"
	local volumeKey="general_storage_volume-${hostID}"

	${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "${volumeKey}" "${newVolume}"
}
MailDirChangePre(){
	if ! MailDirSharePreCheck; then
		return 0
	fi

	## Stop package
	info_log "[Share hook] - Change voluem path so stop postfix and dovecot"
	/var/packages/MailPlus-Server/target/scripts/PostfixCollection.sh stop
	/var/packages/MailPlus-Server/target/scripts/daemon/dovecot.sh stop
}
MailDirChangePost(){
	if ! MailDirSharePreCheck; then
		return 0
	fi

	## Check if volume move success
	if [ "0" == "${RESULT}" ]; then
		## Set new volume
		local volume="$(ParseVolume "${SHARE_PATH}")"
		SetNewVolume "${volume}"
		info_log "[Share hook] - Set new volume to ${volume}"
	else
		err_log "[Share hook] - Move filaed so would not set new volume to ${volume}"
	fi

	## Start package
	log "[Share hook] - Change voluem path done so start postfix and dovecot"
	/var/packages/MailPlus-Server/target/scripts/PostfixCollection.sh start
	/var/packages/MailPlus-Server/target/scripts/daemon/dovecot.sh start
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "2.0";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		MailDirChangePre
		;;
	--post)
		#Actions after share set
		MailDirChangePost
		LogAction
		################################################
		# PS: Service is resumed/disabled by service framework
		################################################
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac

