#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       SHARE_NAME, SHARE_PATH, ENC_ACTION={encrypt|decrypt}, RESULT
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
. /var/packages/MailPlus-Server/target/hook/MailPlusServerShareCommon.sh

#At begining, acquire package settings
PackageInfoGet;

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
        echo "2.0";
    ;;
    --name)
        #Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
    ;;
    --pkg-ver)
        #Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
    ;;
    --vendor)
        #Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
    ;;
    --pre)
    ;;
    --post)
        #Actions after share encrypt action

        #Check if service share
		ARCHIVE_DEST_SHARE=""
		ARCHIVE_ENABLED="no"
		GetArchiveSetting
       
		CHK_SHARE=${SHARE_PATH};
        SvrShareCheck;
        if [ "1" != "${IS_DEST_SHARE}" ]; then
            exit;
        fi

        #Send notification when encrypt/decrypt action is completed
        if [ "encrypt" = "${ENC_ACTION}" ]; then
            if [ "0" = "${RESULT}" -a "yes" == "${ARCHIVE_ENABLED}" ]; then
				${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "archive_enable_schedule" "no"
				SendShareRemoveNotification ${ARCHIVE_DEST_SHARE}
            fi
        fi

        ################################################
        # PS: Service is resumed/disabled by service framework
        ################################################
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
