#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOUserSet()
#	Usable environment variable:
#		NITEMS, ORIGIN_USER_NAME_{n}, USER_NAME_{n}, UID_{n},
#		USER_OP_RESULT_{n}, RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

#At begining, acquire package settings
PackageInfoGet;

SYNO_USER_SET_ACT="user set"

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ACTIVE_DB="${MAIL_SERVER_PKG}/etc/active_list.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"
MAIL_SERVER_BACKEND="${MAIL_SERVER_PKG}/target/bin/syno_mailserver_backend"

UpdateActiveList()
{
	if [ ! -z "$org_name" ] && [ "$org_name" != "$new_name" ]; then

		local new_name_local_part="`getNameLocalPart \"${new_name}\"`"

		if `${MAIL_SERVER_BACKEND} --checkEaiLocalPart ${new_name_local_part}`; then
			sqlite3 $ACTIVE_DB "UPDATE active_member_table SET name='$new_name' WHERE name='$org_name' and type='user';"
		else
			sqlite3 $ACTIVE_DB "DELETE FROM active_member_table WHERE name='$org_name' and type='user';"
		fi
		if [ 0 != $? ]; then
			 err_log "mailserver: [error]: Fail to UPDATE $new_name from active list db"
		fi
	fi
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		if [ ! -e $ACTIVE_DB ]; then
			exit 1;
		fi

		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));
		bl_changed=0
		while [ "$usr_idx" != "$usr_cnt" ]
		do
			eval "org_name=\$ORIGIN_USER_NAME_$usr_idx"
			eval "new_name=\$USER_NAME_$usr_idx"

			if [ x"${org_name}" != x"${new_name}" ]; then
				bl_changed=1
			fi

			UpdateActiveList

			usr_idx=$(($usr_idx + 1));
		done

		#if edit, then regen aliases
		if [ ${bl_changed} -ne 0 ]; then
			$ConfigGen license
			$ConfigGen local_recipients
		fi

		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
