#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

POSTFIX_SH="${MAIL_SERVER_PKG}/target/scripts/daemon/postfix.sh"
DOVECOT_SH="${MAIL_SERVER_PKG}/target/scripts/daemon/dovecot.sh"
HAPROXY_SH="${MAIL_SERVER_PKG}/target/scripts/daemon/haproxy.sh"

generate_haproxy_cert()
{
	local privkey="/usr/local/etc/certificate/MailPlus-Server/postfix/privkey.pem"
	local fullchain="/usr/local/etc/certificate/MailPlus-Server/postfix/fullchain.pem"
	local haproxy_cert_chain="/usr/local/etc/certificate/MailPlus-Server/postfix/privkey_fullchain.pem"

	if [ -f "${haproxy_cert_chain}" ]; then
		rm ${haproxy_cert_chain}
	fi

	cat ${privkey} > ${haproxy_cert_chain}
	echo -e "\n" >> ${haproxy_cert_chain}
	cat ${fullchain} >> ${haproxy_cert_chain}
	echo -e "\n" >> ${haproxy_cert_chain}

	chmod 400 ${haproxy_cert_chain}
	chown MailPlus-Server:MailPlus-Server ${haproxy_cert_chain}
}

reload_postfix()
{
	${POSTFIX_SH} status
	if [ $? == "${SERVICE_RUNNING}" ]; then
		${POSTFIX_SH} reload
	fi

	generate_haproxy_cert

	${HAPROXY_SH} status
	if [ $? == "${SERVICE_RUNNING}" ]; then
		${HAPROXY_SH} restart
	fi
}

reload_dovecot()
{
	${DOVECOT_SH} status
	if [ $? == "${SERVICE_RUNNING}" ]; then
		${DOVECOT_SH} restart
	fi
}

case "$1" in
	postfix)
		reload_postfix
		;;
	dovecot)
		reload_dovecot
		;;
	gen_cert_only)
		generate_haproxy_cert
		;;
	*)
		echo "Usage: $0 {postfix|dovecot|gen_cert_only}" >&2
		exit 1
		;;
esac
