#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupSet()
#	Usable environment variable:
#		ORIGIN_GROUP_NAME, GROUP_NAME, and RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

#At begining, acquire package settings
PackageInfoGet;

SYNO_GROUP_SET_ACT="group set"

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ALIAS_DB="${MAIL_SERVER_PKG}/etc/alias.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

	if [ ! -e $ALIAS_DB ]; then
		exit 1;
	fi

	org_name=$2
	new_name=$3
	(
	if flock -w 30 -x 100; then
		chown MailPlus-Server:MailPlus-Server ${ALIAS_DB_FILE_LOCK}
		chmod 644 ${ALIAS_DB_FILE_LOCK}

		if [ ! -z "$org_name" ] && [ "$org_name" != "$new_name" ]; then
			sqlite3 $ALIAS_DB "UPDATE alias_info_table SET member='$new_name' WHERE member='$org_name' and type=1;"
			if [ 0 != $? ]; then
				err_log "[Alias Group Update]: failed to UPDATE [${org_name}]=>[${new_name}] from alias db"
			fi
		fi

		flock -u 100
		rm ${ALIAS_DB_FILE_LOCK}
	else
		err_log "[Alias Group Update]: failed to get lock [${ALIAS_DB_FILE_LOCK}]"
	fi
	)100> ${ALIAS_DB_FILE_LOCK}


	$ConfigGen virtual_alias
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
