
#small (1.0-0199 < 1.1.0-0200) return 0
#small (1.1.0-0199 < 1.1.0-0200) return 0
#equal (1.1.0-0200 == 1.1.0-0200) return 2
#larger (1.1.0-0200 > 1.1.0-0199) return 1
version_compare()
{
	local BASE_VER=$1
	local TARGET_VER=$2

	# if no base ver, always reture false
	if [ -z "${BASE_VER}" ]; then
		return 0;
	fi

	# getting major, minor, build
	local target_major=`echo "${TARGET_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\1/'`
	local target_minor=`echo "${TARGET_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\2/'`
	local target_maintenance=`echo "${TARGET_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\3/'`
	local target_build=`echo "${TARGET_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\4/'`

	local BASE_VER_NUM=`echo "$BASE_VER" | awk 'BEGIN {FS="."} {print NF}'`
	if [ "${BASE_VER_NUM}" -eq 2 ]; then
		local base_major=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\1/'`
		local base_minor=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\2/'`
		local base_build=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\3/'`
	else
		local base_major=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\1/'`
		local base_minor=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\2/'`
		local base_maintenance=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\3/'`
		local base_build=`echo "${BASE_VER}" | sed 's/^\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\)[.-]\([0-9]*\).*/\4/'`
	fi

	# compare major, version must equal or above limitation
	if [ "$target_major" -lt "$base_major" ]; then
		return 1;
	elif [ "$target_major" -gt "$base_major" ]; then
		return 0;
	fi
	# compare minor
	if [ "$target_minor" -lt "$base_minor" ]; then
		return 1;
	elif [ "$target_minor" -gt "$base_minor" ]; then
		return 0;
	fi
	# compare mminor
	if [ "${BASE_VER_NUM}" -ne 2 ]; then
		if [ "$target_maintenance" -lt "$base_maintenance" ]; then
			return 1;
		elif [ "$target_maintenance" -gt "$base_maintenance" ]; then
			return 0;
		fi
	fi
	# compare build
	if [ "$target_build" -lt "$base_build" ]; then
		return 1;
	elif [ "$target_build" -gt "$base_build" ]; then
		return 0;
	fi
	return 2;
}
