#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
. /usr/syno/etc.defaults/iptables_modules_list

FIREWALL_SERV_NAME="MAILSERVER_PLUS"
FIREWALL_CHAIN="MAILSERVER_PLUS"
FIREWALL_MODS="${KERNEL_MODULES_CORE} ${KERNEL_MODULES_COMMON}"

## Noticce: one rule can only assign 7 range ports or 15 ports
INTERNAL_USED_TCP_PORT="8500:8504,24245,24246,9526:9529,11211,10025,10465,10587"
INTERNAL_USED_UDP_PORT="8502,8503"

iptablesExec()
{
	if ! iptables "$@"; then
		log "Failed to exec [iptables $@]"
		return 1
	fi
	return 0
}

loadFirewallMod()
{
	synomoduletool --insmod ${FIREWALL_SERV_NAME} ${FIREWALL_MODS}
	return 0
}
unloadFirewallMod()
{
	local m=
	local modList=
	for m in ${FIREWALL_MODS}; do
		modList="$m ${modList}"
	done
	synomoduletool --rmmod ${FIREWALL_SERV_NAME} ${modList}
	return 0
}

applyFirewall()
{
	local cluster_peers_ip="$1"
	local ip=

	if [ "" == "${cluster_peers_ip}" ]; then
		return 0
	fi

	if ! loadFirewallMod; then
		log "Failed to load firewall module"
		return 1
	fi

	## Clear rule first
	if ! iptablesExec -F ${FIREWALL_CHAIN}; then
		return 1
	fi

	## Default rule
	if ! iptablesExec -A ${FIREWALL_CHAIN} -i lo -j RETURN; then
		return 1
	fi
	if ! iptablesExec -A ${FIREWALL_CHAIN} -m state --state RELATED,ESTABLISHED -j RETURN; then
		return 1
	fi

	for ip in ${cluster_peers_ip}; do
		if ! iptablesExec -A ${FIREWALL_CHAIN} -s "${ip}" -p tcp -m multiport --dports ${INTERNAL_USED_TCP_PORT} -j ACCEPT; then
			return 1
		fi
		if ! iptablesExec -A ${FIREWALL_CHAIN} -s "${ip}" -p udp -m multiport --dports ${INTERNAL_USED_UDP_PORT} -j ACCEPT; then
			return 1
		fi
	done

	if ! iptablesExec -A ${FIREWALL_CHAIN} -p tcp -m multiport --dports ${INTERNAL_USED_TCP_PORT} -j DROP; then
		return 1
	fi
	if ! iptablesExec -A ${FIREWALL_CHAIN} -p udp -m multiport --dports ${INTERNAL_USED_UDP_PORT} -j DROP; then
		return 1
	fi

	return 0
}

removeFirewall()
{
	iptables -F ${FIREWALL_CHAIN}
	unloadFirewallMod
	return 0
}

case "$1" in
	start)
		if ! applyFirewall "$2"; then
			log "Failed to applyFirewall"
			exit 1
		fi
		;;
	stop)
		removeFirewall
		;;
		*)
		echo "Usage: $0 {start|stop}" >&2
		exit 1
		;;
esac

## Generate firewall refresh flag which is used in MailPlusServerIPChange.sh
touch "${FIREWALL_REFRESH_FLAG}"

exit 0
