#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

#This is focus on "dayli quota"

MEMCACHED="${MAIL_SERVER_PKG}/target/usr/bin/memcached"
PID_FILE="/var/run/mailplus_server/mailserver_memcached.pid"
MEMCACHED_PORT=11211

checkMemcachedStatus()
{
	local target_proc_name=$1
	local target_pid_file=$2
	local noneed_filter=$3
	#echo " checkDirectorStatus ----- ${target_proc_name} ---- ${target_pid_file} ----- ${noneed_filter} ----- "
	if [ x"`/bin/pidof "${target_proc_name}"`" != x"" ] ; then
		if [ -f "${target_pid_file}" ] ; then
			local pid=`cat "${target_pid_file}"`
			if [ 0 != `ps -I | grep "${target_proc_name}" | grep -v "${noneed_filter}" | grep "${pid}" | wc -l` ] ; then
				#echo "I'm running"
				return "${SERVICE_RUNNING}"
			else
				return "${SERVICE_DEAD_FPID}"
			fi
		else
			#grep will has one process
			if [ 0 != `ps -I | grep "${target_proc_name}" | grep  "${PID_FILE}" | grep -v "grep" | grep -v "${noneed_filter}" | grep -v "memcached.sh" | wc -l` ] ; then
				#echo "I'm running"
				return "${SERVICE_RUNNING}"
			else
				#echo "I'm not running"
				return "${SERVICE_NOT_RUNNING}"
			fi
		fi
	else
		if [ -f "${target_pid_file}" ] ; then
			return "${SERVICE_DEAD_FPID}"
		else
			#echo "I'm not running"
			return "${SERVICE_NOT_RUNNING}"
		fi
	fi > /dev/null
}

bin_status()
{
	#[FIXME] If dailyquota is setted, need to check port, if not, check instance for setfile
	checkMemcachedStatus "memcached" "${PID_FILE}" "mailserver_config_memcached"
	return $?
}

port_status()
{
	checkPortUseStatus "memcached" "${MEMCACHED_PORT}" "0.0.0.0"
}

status()
{
	bin_status
	local memcache_status=$?
	if [ "${SERVICE_NOT_RUNNING}" -eq ${memcache_status} ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${memcache_status}

	if [ "${SERVICE_RUNNING}" -ne ${memcache_status} ]; then
		return ${memcache_status}
	fi
	port_status
	local memcache_port=$?
	return ${memcache_port}
}

start()
{
	${MEMCACHED} -u MailPlus-Server -U 0 -d -P ${PID_FILE}

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status memcached: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}
}

checkStopped()
{
	local pid="$(cat ${PID_FILE})"
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		if ! ps -p ${pid} > /dev/null; then
			# memcached is terminated
			break
		fi
		sleep "${SLEEP_TIME}"
	done

	# if memcached still exists, force stop it
	if ps -p ${pid} > /dev/null; then
		kill -9 ${pid} &> /dev/null
	fi
}

stop()
{
	kill `cat ${PID_FILE}` &> /dev/null
	checkStopped

	rm ${PID_FILE} &> /dev/null
}

restart()
{
	stop
	sleep 1
	start
}

composePort()
{
	echo "${MEMCACHED_PORT}"
}

composeIP()
{
	echo "0.0.0.0"
}

composeProtocol()
{
	echo "tcp"
}

composePID()
{
	local pid=$(cat ${PID_FILE} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/memcached.sh"
}

case "$1" in
	start)
		startOperation "mailserver_service_memcached"
		;;
	restart)
		restartOperation "mailserver_service_memcached"
		;;
	stop)
		stopOperation "mailserver_service_memcached"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|reload|status}" >&2
		exit 1
		;;
esac
