#!/bin/bash
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

MAILPLUS_SERVER_IP_CHANGE_LOCK_FILE="/tmp/mailplus_server/ip_post_change.lock"
CLUSTER_LOCK_KEY="change_ip"

hookPreCheck()
{
	# do nothing when interface change on shutdown step
	if /usr/syno/bin/synobootseq --is-shutdown > /dev/null 2>&1 ; then
		exit 0
	fi
	# do nothing when booting, we'll run this in upstart when booting is done.
	if /usr/syno/bin/synobootseq --is-booting-up > /dev/null 2>&1 ; then
		exit 0
	fi
}

updateNodeList()
{
	local nodeID="$(getHostID)"
	local nodeIPList="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostIPList)"
	local key="node_ip_list-${nodeID}"

	nodeIPList=$(echo "${nodeIPList}" | sed -e "s/${ORIGIN_ADDRESS}\>/${NEW_ADDRESS}/")

	## Remove execute command flag
	rm -fr "${FIREWALL_REFRESH_FLAG}"

	info_log "[MailPlusServerIPChange] - start updateNodeList"
	if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "${key}" "${nodeIPList}"; then
		 err_log "[MailPlusServerIPChange] - Failed to update node ip list [${key}] to [${nodeIPList}] when ip change"
	fi

	local hostIP=$(getHostIP)
	if checkIfWeCare; then
		for i in $(seq 1 1 10); do
			if [ -e "${FIREWALL_REFRESH_FLAG}" ];then
				rm -fr "${FIREWALL_REFRESH_FLAG}"
				break
			fi
			info_log "[MailPlusServerIPChange] - Wait for firewall refresh..."
			sleep 1
		done
	fi
	info_log "[MailPlusServerIPChange] - done updateNodeList"
}

checkIfWeCare()
{
	## Check if interface/ip is mailplus server used interface/ip
	local hostIP=$(getHostIP)
	local hostIF=$(getHostIF)
	if [ -n "${hostIF}" ]; then
		if  [ "${hostIF}" == "${IFNAME}" ]; then
			return 0
		fi
	else [ "${ORIGIN_ADDRESS}" == "${hostIP}" ];
		return 0
	fi
	return 1
}
updateBackendPre()
{
	if ! checkIfWeCare; then
		return 0
	fi

	# acquire lock for change ip
	for i in $(seq 1 1 120); do
		if acquireClusterLock "${CLUSTER_LOCK_KEY}" "60"; then
			break
		fi
		info_log "[MailPlusServerIPChange] - Wait for firewall refresh..."
		sleep 1
	done

	info_log "[MailPlusServerIPChange] - start updateBackendPre"

	local hostID="$(getHostID)"
	${MAILPLUS_SERVER_BACKEND_BINARY} --setServSync mailserver_service_dovecot "${hostID}"

	## Notify new master IP, NOTICE: here load balancer equal redis master
	local masterIP="$(${BACKEND_BINARY} backend-command --command get_redis_master_ip)"
	local nodeNum="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getPeersNum)"
	local hostIF=$(getHostIF)
	if [ "${nodeNum}" -gt 1 -a "127.0.0.1" == "${masterIP}" ] ; then
		# There are 2 nodes, and I am master node
		${BACKEND_BINARY} "backend-command" --command "set" --key "/tmp/new_master_ip" --value "${NEW_ADDRESS}" --ttl "60"
	fi
	info_log "[MailPlusServerIPChange] - done updateBackendPre"
}
updateBackendPost()
{
	local newHostIP="${NEW_ADDRESS}"
	info_log "[MailPlusServerIPChange] - start updateBackendPost [${newHostIP}]"

	## update certificate have to before updateSelfMapping to avoid get old certificate
	if ! GenerateInternalCert "onlyCert"; then
		err_log "[MailPlusServerIPChange] - Failed to regen certificate according new IP"
	fi

	if ! checkIfWeCare; then
		info_log "[MailPlusServerIPChange] - quick done updateBackendPost"
		return 0
	fi

	if [ -n "${newHostIP}" ]; then
		## update backend config and mapping table
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --updateSelfMapping "${newHostIP}"; then
			err_log "[MailPlusServerIPChange] - Failed to regen mailplus server id-ip mapping table"
		fi
	else
		 err_log "[MailPlusServerIPChange] - skip updateSelfMapping because ip is none"
	fi

	local hostID="$(getHostID)"
	${MAILPLUS_SERVER_BACKEND_BINARY} --setServSyncDone mailserver_service_dovecot "${hostID}"

	releaseClusterLock "${CLUSTER_LOCK_KEY}"
	info_log "[MailPlusServerIPChange] - done updateBackendPost"
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "MailPlus-Server";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
		hookPreCheck

		updateBackendPre
		updateNodeList
	;;
	--post)
		hookPreCheck
		if ! $MAILPLUS_SERVER_BACKEND_BINARY --isIFStatic "${IFNAME}"; then
			#interface is not static, and thus may not trigger pre event
			updateBackendPre
			updateNodeList
		fi
		(
		if flock -n -x 8; then
			## avoid exec many times when encounter series net interface change event
			sleep 1
			flock -u 8
			rm ${MAILPLUS_SERVER_IP_CHANGE_LOCK_FILE}

			updateBackendPost
		fi
		)8> ${MAILPLUS_SERVER_IP_CHANGE_LOCK_FILE} &
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

