#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh
. /var/packages/MailPlus-Server/target/scripts/DsmVersionUtil.sh

HOOK_DIR="/var/packages/MailPlus-Server/target/hook"
DIR_SRV_HOOK="${HOOK_DIR}/dir_service_hook"

SYNO_MAILPLUS_SERVERD_SCRIPT="/var/packages/MailPlus-Server/target/scripts/daemon/syno_mailserverd.sh"

case $1 in
	--sdk-mod-ver)
		${DIR_SRV_HOOK} --sdk-mod-ver;
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--pre)
		;;
	--post)
		#check if the package is enabled
		if ! isPackageEnable; then
			exit 0;
		fi

		#Daemon will use getpwuid_r, so need restart after join it
		${SYNO_MAILPLUS_SERVERD_SCRIPT} status
		if [ "${SERVICE_RUNNING}" -eq $? ]; then
			${SYNO_MAILPLUS_SERVERD_SCRIPT} restart
		fi
		;;
	*)
	;;
esac
