#!/usr/bin/env python
# --*-- coding:utf8 --*--

def execCommand(args):
    from subprocess import Popen, STDOUT, PIPE

    try:
        process = Popen(args, stdout=PIPE, stderr=STDOUT)
        output = process.stdout.read().strip()
        process.communicate()
        ret = process.returncode == 0
        return output, ret
    except:
        if debug:
            writeLog(u'Failed to execute command:{0}'.format(u' '.join(args)))
        return '', False

def converToPunycodeAddr(addr):
    at_idx = addr.rfind('@')
    if at_idx == -1:
        return addr
    local_part = addr[:at_idx]
    domain_part = addr[at_idx + 1:]
    return u'{0}@{1}'.format(local_part, domain_part.encode('idna'))

def converToEaiAddr(addr):
    at_idx = addr.rfind('@')
    if at_idx == -1:
        return addr
    local_part = addr[:at_idx]
    domain_part = addr[at_idx + 1:]
    return u'{0}@{1}'.format(local_part, domain_part.decode('idna'))

def getFullUsername(username):
    args = ['/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend', '--getFullUsername', username.encode('utf8')]
    return execCommand(args)[0]

def getUserAddress(fullUsername):
    # Check if we can use set for performance issue
    punycode_address = []
    args = ['/var/packages/MailPlus-Server/target/bin/syno_multiple_domains', 'get_all_mail_addrs', fullUsername]
    for addr in execCommand(args)[0].split('\n'):
        punycode_address.append(converToPunycodeAddr(addr.decode('utf8')).lower())

    return punycode_address

