package MailPlusServer::ReportMailFilter;

use strict;
use warnings;

use Encode;
use MIME::Base64;
use MailPlusServer::Log;
use MailPlusServer::Util;

sub new {
	my $class = shift;
	my $config = shift;
	my $self = {};

	$self->{spam_report_enable}  = $config->{spam_report_enable};
	$self->{spam_report_account} = $config->{spam_report_account};
	$self->{ham_report_account}  = $config->{ham_report_account};
	$self->{local_domain_map}    = $config->{local_domain_map};

	bless ($self, $class);
}

sub extract_report_mails {
	my ($self, $entity) = @_;
	my @parts = $entity->parts;
	my @mails = ();

	foreach my $p (@parts) {
		my $fh;
		my $attached_mail = '';
		my $header = $p->head();
		my $filename = '';
		if ($header->recommended_filename) {
			$filename = Encode::decode('MIME-Header', $header->recommended_filename);
		}
		my $is_from_mailplus = ($filename =~ /^syno_report_mail_/);
		if ($p->mime_type eq "message/rfc822" || $is_from_mailplus) {
			my $attached_mail = MailPlusServer::Util::entity_print_body($p);

			if ($is_from_mailplus) {
				$attached_mail = decode_base64($attached_mail);
			}

			push(@mails, $attached_mail);
		}
	}

	return \@mails;
}

sub get_info {
	my ($self, $recipients_aref) = @_;

	my $is_report_mail = 0;
	my $report_account = '';

	if (!$self->{spam_report_enable}) {
		return ($is_report_mail, $report_account);
	}

	for my $recipient (@{$recipients_aref}) {
		my $Recipient = MailPlusServer::Util::trim_angle_bracket($recipient);
		my ($recipient_name, $recipient_domain) = MailPlusServer::Util::split_mail_address_to_utf8($Recipient);

		$recipient_name = lc $recipient_name;
		$recipient_domain = lc $recipient_domain;

		if (($recipient_name eq $self->{ham_report_account} || $recipient_name eq $self->{spam_report_account}) && exists($self->{local_domain_map}->{$recipient_domain})) {
			$is_report_mail = 1;
			$report_account = $recipient_name;
			last;
		}
	}

	return ($is_report_mail, $report_account);
}

sub collect_report_mails {
	my ($self, $recipients_aref, $entity) = @_;
	my ($is_report_mail, $report_account) = $self->get_info($recipients_aref);

	if ($is_report_mail) {
		foreach my $mail (@{$self->extract_report_mails($entity)}) {
			# use lda to sendmail
			MailPlusServer::Util::lda_send_mail('', $report_account, $mail);
		}
	}

	return $is_report_mail;
}

1;
