package MailPlusServer::Disclaimer;

use strict;
use warnings;
use Encode;
use utf8;

use Net::IDN::Encode qw/domain_to_ascii/;

use MailPlusServer::Log;
use MailPlusServer::Util;

sub new {
	my $class = shift;
	my $config = shift;
	my $self = {};

	$self->{gid_username_map} = $config->{gid_username_map};
	$self->{local_domain_map} = $config->{local_domain_map};
	$self->{disclaimer_list}  = $config->{disclaimer_list};

	bless ($self, $class);
}

sub get_disclaimer {
	my ($self, $Sender, $RecipientListRef) = @_;
	my $SenderName = '';
	my $SenderDomain = '';

	my %local_domain_map = %{$self->{local_domain_map}};
	my %gid_username_map = %{$self->{gid_username_map}};

	my $has_disclaimer = 0;
	my $content_txt = '';
	my $content_html = '';
	my $all_local_recipient = 1;
	my $domain_id = -1;

	$Sender = MailPlusServer::Util::trim_angle_bracket($Sender);
	($SenderName, $SenderDomain) = MailPlusServer::Util::split_mail_address_to_utf8($Sender);

	if ($SenderDomain ne '') {
		$SenderDomain = domain_to_ascii($SenderDomain);
		$Sender = $SenderName . '@' . $SenderDomain;
	}

	# check whether it is a outbound mail
	if (!exists($local_domain_map{lc $SenderDomain})) {
		# not outbond mail, so no disclaimer
		return (0, '', '');
	}

	# check whether all recipients are local recipients
	foreach my $Recipient (@{$RecipientListRef}) {
		$Recipient = MailPlusServer::Util::trim_angle_bracket($Recipient);
		my ($RecipientName, $RecipientDomain) = MailPlusServer::Util::split_mail_address_to_utf8($Recipient);

		if (!exists($local_domain_map{lc $RecipientDomain})) {
			$all_local_recipient = 0;
			last;
		}
	}

	foreach my $domain_name (keys %local_domain_map) {
		if ($domain_name eq $SenderDomain) {
			$domain_id = $local_domain_map{$domain_name};
			last;
		}
	}

	if ($domain_id eq -1) {
		MailPlusServer::Log::ErrorLog("Failed to get domain_id of the sender: '$Sender'");
	}


	CHECK_LOOP:
	foreach my $disclaimer (@{$self->{disclaimer_list}->{$domain_id}}) {
		if ($all_local_recipient && $disclaimer->{disabled_for_local_recipient}) {
			next;
		}

		foreach (@{$RecipientListRef}) {
			# syslog('ERR', "Sender: '$Sender'");
			# syslog('ERR', "Recipient: '$Recipient'");
			my $Recipient = MailPlusServer::Util::trim_angle_bracket($_);
			my ($RecipientName, $RecipientDomain) = MailPlusServer::Util::split_mail_address_to_utf8($Recipient);

			if ($RecipientDomain ne '') {
				$RecipientDomain = domain_to_ascii($RecipientDomain);
				$Recipient = $RecipientName . '@' . $RecipientDomain;
			}

			my $match;
			my $eval_str = "\$match = $disclaimer->{condition}; 1;";
			eval($eval_str) or do {
				MailPlusServer::Log::ErrorLog("Failed to eval condition: '$disclaimer->{condition}', $@");
			};
			next if !$match;

			$has_disclaimer = 1;
			$content_txt = $disclaimer->{content_txt};
			$content_html = $disclaimer->{content_html};
			last CHECK_LOOP;
		}
	}

	if ($has_disclaimer) {
		$content_txt = Encode::encode_utf8($content_txt);
		$content_html = Encode::encode_utf8($content_html);
	}
	return ($has_disclaimer, $content_txt, $content_html);
}

1;
