#!/bin/sh

SetInterface()
{
	local HOST_IF=`/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend --getHostIF`
	local HOST_ID=`/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend --getHostID`
	local KEY="node_bind_if-${HOST_ID}"
	local VALUE="${HOST_IF}"
	if [ "${ACTION}" == "create" ]; then
		if [[ ! "${HOST_IF}" =~ "ppp"[0-9] ]]; then
		#not pppoe interface
			VALUE="ovs_${HOST_IF}"
		fi
	elif [ "${ACTION}" == "delete" ]; then
		if [[ "${HOST_IF}" =~ ^"ovs_" ]]; then
		#not ovs interface
			VALUE="${HOST_IF:4}"
		fi
	else
		return 1
	fi
	/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend --setConfKeyVal "${KEY}" "${VALUE}"
	return 0
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "MailPlus-Server";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
	;;
	--post)
		SetInterface
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

