#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupDelete()
#	Usable environment variable:
#		GROUP_NAME_N, GROUP_OP_RESULT_N, NITEMS and RESULT
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

#At begining, acquire package settings
PackageInfoGet;
MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ACTIVE_DB="${MAIL_SERVER_PKG}/etc/active_list.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		if [ ! -e $ACTIVE_DB ]; then
			exit 1;
		fi

		group_idx=1;
		group_cnt=$(($NITEMS + 1));
		while [ "$group_idx" != "$group_cnt" ]
		do
			eval "group_name=\$GROUP_NAME_$group_idx"

			if [ ! -z "$group_name" ]; then

				sqlite3 $ACTIVE_DB "DELETE FROM active_member_table WHERE name='$group_name' and type='group';"

				if [ 0 != $? ]; then
					err_log "[LicenseGroupDelete]: failed to delete $group_name from active_list db"
				fi

			fi

			group_idx=$(($group_idx + 1));
		done
		$ConfigGen license
		$ConfigGen local_recipients

		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
