#!/bin/sh

###############################################################
#   This script should be hooked when invoking user delete
#   Usable environment variable:
#       NITEMS, USER_NAME_X, USER_OP_RESULT_X, RESULT
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

#At begining, acquire package settings
PackageInfoGet;

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
MAIL_SERVER_DB="${MAIL_SERVER_PKG}/etc/mailserver.db"
SYNO_MULTIPLE_DOMAIN="${MAIL_SERVER_PKG}/target/bin/syno_multiple_domains"


case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		if [ ! -e ${MAIL_SERVER_DB} ]; then
			exit 0;
		fi

		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));

		while [ "$usr_idx" != "$usr_cnt" ]
		do
			eval "uid=\$UID_$usr_idx"
			if [ ! -z "$uid" ]; then
				sqlite3 ${MAIL_SERVER_DB} "UPDATE multi_domain_enable_table SET en_catch_all = '0' WHERE domain_id IN (SELECT domain_id FROM multi_domain_rate_table WHERE catch_all = '$uid');"
				if [ 0 != $? ]; then
					err_log "[Disable Catch all After User Delete]: failed to disable catch all user $uid from mailserver db"
				fi
				sqlite3 ${MAIL_SERVER_DB} "UPDATE multi_domain_rate_table SET catch_all = '-1' WHERE catch_all = '$uid';"
				if [ 0 != $? ]; then
					err_log "[Catch all User Delete]: failed to delete $uid from mailserver db"
				fi
			fi
			usr_idx=$(($usr_idx + 1));
		done
		${SYNO_MULTIPLE_DOMAIN} refresh_domain_usage_settings
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
