#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOUserSet()
#	Usable environment variable:
#		NITEMS, ORIGIN_USER_NAME_{n}, USER_NAME_{n}, UID_{n},
#		USER_OP_RESULT_{n}, RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

#At begining, acquire package settings
PackageInfoGet;

SYNO_USER_SET_ACT="user set"

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ALIAS_DB="${MAIL_SERVER_PKG}/etc/alias.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"
AccountType="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "account_type")"
: ${AccountType:="local"}
MAIL_SERVER_BACKEND="${MAIL_SERVER_PKG}/target/bin/syno_mailserver_backend"

UpdateAlias()
{
	if [ ! -z "$org_name" ] && [ "$org_name" != "$new_name" ]; then
		if `${MAIL_SERVER_BACKEND} --checkEaiLocalPart ${new_name_local_part}`; then
			sqlite3 $ALIAS_DB "UPDATE alias_info_table SET member='$new_name' WHERE member='$org_name' and type=0;"
		else
			sqlite3 $ALIAS_DB "DELETE FROM alias_info_table WHERE member='$org_name' and type=0;"
		fi
		if [ 0 != $? ]; then
			err_log "[Alias User Update]: failed to UPDATE [${org_name}]=>[${new_name}] from alias db"
		fi
	fi
}

UpdateAutoReply()
{
	local VACATION_FILES="`ls -a ${MAILDIR_DIR} | grep -E \"^\..*\.msg$\"`"

	for FILE in ${VACATION_FILES}
	do
		local FULL_FILE_PATH="${MAILDIR_DIR}/${FILE}"
		if [ ! -z "$org_name" ] && [ -e "${FULL_FILE_PATH}" ]; then
			sed s/"From:$org_name_local_part"/"From:$new_name_local_part"/g "${FULL_FILE_PATH}" > /tmp/reply.tmp.$$
			mv /tmp/reply.tmp.$$ "${FULL_FILE_PATH}"
		fi
	done
}

UpdateAutoForward()
{
	local FORWARD="${MAILDIR_DIR}/.forward"
	local orgTmp="\\\\"$org_name_local_part
	local newTmp="\\\\"$new_name_local_part
	if [ ! -z "$org_name" ] && [ -e "${FORWARD}" ]; then
		cat "${FORWARD}" | sed s/"$orgTmp"/"$newTmp"/g | sed s/"vacation $org_name_local_part"/"vacation $new_name_local_part"/g > /tmp/forward.$$
		mv /tmp/forward.$$ "${FORWARD}"
	fi
}


case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		if [ ! -e $ALIAS_DB ]; then
			exit 1;
		fi

		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));
		alias_updated=false
		(
		if flock -w 30 -x 100; then
			chown MailPlus-Server:MailPlus-Server ${ALIAS_DB_FILE_LOCK}
			chmod 644 ${ALIAS_DB_FILE_LOCK}

			while [ "$usr_idx" != "$usr_cnt" ]
			do
				eval "org_name=\$ORIGIN_USER_NAME_$usr_idx"
				eval "new_name=\$USER_NAME_$usr_idx"

				org_name_local_part="`getNameLocalPart \"${org_name}\"`"
				new_name_local_part="`getNameLocalPart \"${new_name}\"`"
				MAILDIR_DIR="`${MAIL_SERVER_PKG}/target/bin/syno_mailserver_backend --getMailDir \"$new_name\"`"

				UpdateAlias
				if [ ! -z "${MAILDIR_DIR}" ]; then
					alias_updated=true
					UpdateAutoReply
					UpdateAutoForward
				fi

				usr_idx=$(($usr_idx + 1));
			done

			flock -u 100
			rm ${ALIAS_DB_FILE_LOCK}
		else
			err_log "[Alias User Update]: failed to get lock [${ALIAS_DB_FILE_LOCK}]"
		fi
		)100> ${ALIAS_DB_FILE_LOCK}

		#if edit, then regen aliases
		if [ "${alias_updated}" == "true" ]; then
			$ConfigGen virtual_alias
		fi

		#gen new user login map, only if enable restrict sender and account is local
		restrictSender="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "restrict_sender")"
		if [ x"${restrictSender}" = x"yes" -a x"${AccountType}" = x"local" ]; then
			${MAIL_SERVER_PKG}/target/bin/syno_gen_login_map
		fi

		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
